/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.geo.swing;

import de.datomino.util.geo.ImmutableGeoObject;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutableMultiPolygon;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.ImmutablePolygon;
import de.datomino.util.geo.ImmutablePolygonKind;
import de.datomino.util.geo.model.GeomExtractor;
import de.datomino.util.geo.swing.renderer.AreaRenderer;
import de.datomino.util.geo.swing.renderer.LineRenderer;
import de.datomino.util.geo.swing.renderer.PointRenderer;
import de.datomino.util.geo.swing.renderer.RendererProperties;
import de.datomino.util.swing.blocking.BusyHandler;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.swing.navigator.AbstractNavigatorRenderer;
import org.ktde.swing.navigator.OnTopRendering;
import org.ktde.util.datatypes.Tripel;
import org.slf4j.Logger;

public abstract class AbstractGeometryNavigatorRenderer<S, T extends ImmutableGeoObject>
extends AbstractNavigatorRenderer {
    private double maxUpp;
    private double minUpp;
    private GeomExtractor<S, T> geomExtractor;
    private BusyHandler busyHandler;

    public AbstractGeometryNavigatorRenderer(String name, GeomExtractor<S, T> geomExtractor) {
        this(name, 0.0, 50.0, geomExtractor);
    }

    public AbstractGeometryNavigatorRenderer(String name, double minUpp, double maxUpp, GeomExtractor<S, T> geomExtractor) {
        super(name);
        this.geomExtractor = geomExtractor;
        this.minUpp = minUpp;
        this.maxUpp = maxUpp;
        this.setActive(true);
    }

    public double getMaxUpp() {
        return this.maxUpp;
    }

    public double getMinUpp() {
        return this.minUpp;
    }

    @Override
    public void prepare(Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
        if (!this.isActive() || upp > this.getMaxUpp() || upp < this.getMinUpp()) {
            return;
        }
        CoordinateFactory factory = this.getPanel().getCoordinateFactory();
        this.prepare(factory.createCoordinate(realBoundaryBottomLeft.getX(), realBoundaryBottomLeft.getY()), factory.createCoordinate(realBoundaryTopRight.getX(), realBoundaryTopRight.getY()), upp);
    }

    protected void prepare(Coordinate realBoundaryBottomLeft, Coordinate realBoundaryTopRight, double upp) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.info("PreFetching");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<OnTopRendering> paintOnto(Graphics2D g2d, Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
        if (!this.isActive() || upp > this.getMaxUpp() || upp < this.getMinUpp()) {
            return Collections.emptyList();
        }
        try {
            if (this.busyHandler != null) {
                this.busyHandler.start();
            }
            CoordinateFactory factory = this.getPanel().getCoordinateFactory();
            Collection<S> models = this.getGeometries(factory.createCoordinate(realBoundaryBottomLeft.getX(), realBoundaryBottomLeft.getY()), factory.createCoordinate(realBoundaryTopRight.getX(), realBoundaryTopRight.getY()), upp);
            int cycles = this.getCycles();
            for (int i = 0; i < cycles; ++i) {
                for (S model : models) {
                    if (!this.isAllowed(model)) continue;
                    this.paintOnto(g2d, upp, factory, model, i);
                }
            }
        }
        finally {
            if (this.busyHandler != null) {
                this.busyHandler.stop();
            }
        }
        return Collections.emptyList();
    }

    public boolean isAllowed(S model) {
        return true;
    }

    private <U extends RendererProperties, V extends RendererProperties, W extends RendererProperties> void paintOnto(Graphics2D g2d, double upp, CoordinateFactory factory, S model, int cycle) {
        Collection<Tripel<AreaRenderer<U, S>, LineRenderer<V, S>, PointRenderer<W, S>>> renderers = this.getRenderersForModel(model, cycle);
        for (Tripel<AreaRenderer<U, S>, LineRenderer<V, S>, PointRenderer<W, S>> tupel : renderers) {
            PointRenderer<W, S> pointRenderer;
            RendererProperties pointRendererProperties;
            LineRenderer<V, S> lineRenderer;
            RendererProperties lineRendererProperties;
            RendererProperties areaRendererProperties;
            AreaRenderer<U, S> areaRenderer = tupel.getElement1();
            RendererProperties rendererProperties = areaRendererProperties = areaRenderer == null ? null : (RendererProperties)areaRenderer.createRendererProperties(model);
            if (areaRendererProperties != null) {
                areaRendererProperties.setUpp(upp);
            }
            RendererProperties rendererProperties2 = lineRendererProperties = (lineRenderer = tupel.getElement2()) == null ? null : (RendererProperties)lineRenderer.createRendererProperties(model);
            if (lineRendererProperties != null) {
                lineRendererProperties.setUpp(upp);
            }
            RendererProperties rendererProperties3 = pointRendererProperties = (pointRenderer = tupel.getElement3()) == null ? null : (RendererProperties)pointRenderer.createRendererProperties(model);
            if (pointRendererProperties != null) {
                pointRendererProperties.setUpp(upp);
            }
            this.render(model, g2d, areaRenderer, areaRendererProperties, lineRenderer, lineRendererProperties, pointRenderer, pointRendererProperties, factory, upp, cycle);
        }
    }

    protected abstract <U extends RendererProperties, V extends RendererProperties, W extends RendererProperties> Collection<Tripel<AreaRenderer<U, S>, LineRenderer<V, S>, PointRenderer<W, S>>> getRenderersForModel(S var1, int var2);

    protected abstract Collection<S> getGeometries(Coordinate var1, Coordinate var2, double var3);

    public <U extends RendererProperties, V extends RendererProperties, W extends RendererProperties> void render(S model, Graphics2D g2d, AreaRenderer<U, S> areaRenderer, U areaRendererProperties, LineRenderer<V, S> lineRenderer, V lineRendererProperties, PointRenderer<W, S> pointRenderer, W pointRendererProperties, CoordinateFactory factory, double upp, int cycle) {
        Object geom = this.getGeomToPaint(model, upp);
        if (geom != null) {
            if ((geom = geom.getTransformed(factory).snapToGrid(upp)) instanceof ImmutablePoint) {
                this.drawPoint(g2d, model, (ImmutablePoint)geom, pointRenderer, pointRendererProperties, cycle);
            } else if (geom instanceof ImmutableLineString) {
                this.drawLineString(g2d, model, (ImmutableLineString)geom, lineRenderer, lineRendererProperties, cycle);
            } else if (geom instanceof ImmutablePolygonKind) {
                this.drawPolygon(g2d, model, (ImmutablePolygonKind)geom, areaRenderer, areaRendererProperties, lineRenderer, lineRendererProperties, cycle);
            } else {
                throw new IllegalArgumentException("Not supported geoObject: " + geom);
            }
        }
    }

    protected T getGeomToPaint(S model, double upp) {
        return this.getGeomExtractor().getGeom(model);
    }

    protected <U extends RendererProperties, V extends RendererProperties> void drawPolygon(Graphics2D g2d, S model, ImmutablePolygonKind geom, AreaRenderer<U, S> areaRenderer, U areaRendererProperties, LineRenderer<V, S> lineRenderer, V lineRendererProperties, int cycle) {
        if (areaRenderer != null) {
            areaRenderer.render(g2d, (ImmutablePolygonKind)model, geom, (S)areaRendererProperties);
        }
        if (lineRenderer != null) {
            AbstractList borders = null;
            if (geom instanceof ImmutablePolygon) {
                ImmutablePolygon polygon = (ImmutablePolygon)geom;
                List<ImmutableLineString> holes = polygon.getHoles();
                borders = new ArrayList(holes.size() + 1);
                borders.addAll(holes);
                borders.add(polygon.getShell());
            } else if (geom instanceof ImmutableMultiPolygon) {
                ImmutableMultiPolygon polygon = (ImmutableMultiPolygon)geom;
                borders = new LinkedList();
                for (ImmutablePolygon part : polygon.getParts()) {
                    borders.add(part.getShell());
                    borders.addAll(part.getHoles());
                }
            }
            if (borders != null) {
                lineRenderer.render(g2d, model, borders, lineRendererProperties);
            }
        }
    }

    protected <V extends RendererProperties> void drawLineString(Graphics2D g2d, S model, ImmutableLineString geom, LineRenderer<V, S> lineRenderer, V lineRendererProperties, int cycle) {
        if (lineRenderer != null) {
            lineRenderer.render(g2d, (ImmutableLineString)model, geom, lineRendererProperties);
        }
    }

    protected <W extends RendererProperties> void drawPoint(Graphics2D g2d, S model, ImmutablePoint geom, PointRenderer<W, S> pointRenderer, W rendererProperties, int cycle) {
        if (pointRenderer != null) {
            pointRenderer.render(g2d, (ImmutablePoint)model, geom, rendererProperties);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        AbstractGeometryNavigatorRenderer clone = (AbstractGeometryNavigatorRenderer)super.clone();
        return clone;
    }

    protected int getCycles() {
        return 1;
    }

    protected Logger getLogger() {
        return null;
    }

    public void setBusyHandler(BusyHandler busyHandler) {
        this.busyHandler = busyHandler;
    }

    protected GeomExtractor<S, T> getGeomExtractor() {
        return this.geomExtractor;
    }
}

