/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.geo.swing;

import de.datomino.util.ValueChangeObservable;
import de.datomino.util.geo.ImmutableGeoObject;
import de.datomino.util.geo.model.GeoObjectBucketsChangeListener;
import de.datomino.util.geo.model.GeoObjectBucketsChangedEvent;
import de.datomino.util.geo.model.GeoObjectBucketsModel;
import de.datomino.util.geo.model.GeomExtractor;
import de.datomino.util.geo.swing.AbstractGeometryNavigatorStaticRenderer;
import de.datomino.util.geo.swing.renderer.AreaRenderer;
import de.datomino.util.geo.swing.renderer.LineRenderer;
import de.datomino.util.geo.swing.renderer.PointRenderer;
import java.util.Collection;
import org.ktde.math.projection.Coordinate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBucketNavigatorStaticRenderer<S extends ValueChangeObservable, T extends ImmutableGeoObject>
extends AbstractGeometryNavigatorStaticRenderer<S, T>
implements GeoObjectBucketsChangeListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractBucketNavigatorStaticRenderer.class);
    private GeoObjectBucketsModel<S, T> bucketsModel;

    public AbstractBucketNavigatorStaticRenderer(String name, GeoObjectBucketsModel<S, T> bucketsModel, AreaRenderer<?, S> areaRenderer, LineRenderer<?, S> lineRenderer, PointRenderer<?, S> pointRenderer, GeomExtractor<S, T> geomExtractor) {
        super(name, areaRenderer, lineRenderer, pointRenderer, geomExtractor);
        this.bucketsModel = bucketsModel;
        this.bucketsModel.addGeoObjectBucketsChangeListener(this);
    }

    public AbstractBucketNavigatorStaticRenderer(String name, GeoObjectBucketsModel<S, T> bucketsModel, double minUpp, double maxUpp, AreaRenderer<?, S> areaRenderer, LineRenderer<?, S> lineRenderer, PointRenderer<?, S> pointRenderer, GeomExtractor<S, T> geomExtractor) {
        super(name, minUpp, maxUpp, areaRenderer, lineRenderer, pointRenderer, geomExtractor);
        this.bucketsModel = bucketsModel;
        this.bucketsModel.addGeoObjectBucketsChangeListener(this);
    }

    public GeoObjectBucketsModel<S, T> getBucketsModel() {
        return this.bucketsModel;
    }

    public void setBucketsModel(GeoObjectBucketsModel<S, T> bucketsModel) {
        this.bucketsModel = bucketsModel;
    }

    @Override
    protected Collection<S> getGeometries(Coordinate bottomLeft, Coordinate topRight, double upp) {
        return this.bucketsModel.findObjects(bottomLeft, topRight);
    }

    @Override
    public void geoBucketsChanged(GeoObjectBucketsChangedEvent e) {
        this.callRepaint();
    }

    @Override
    public void close() {
        super.close();
        this.bucketsModel.clear();
    }
}

