/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.geo.swing;

import de.datomino.util.ValueChangeObservable;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.geo.ImmutableGeoObject;
import de.datomino.util.geo.model.GeoObjectBucketsChangeListener;
import de.datomino.util.geo.model.GeoObjectBucketsChangedEvent;
import de.datomino.util.geo.model.GeoObjectBucketsModel;
import de.datomino.util.geo.model.GeomExtractor;
import de.datomino.util.geo.swing.AbstractGeometryNavigatorStaticRenderer;
import de.datomino.util.geo.swing.renderer.AreaRenderer;
import de.datomino.util.geo.swing.renderer.LineRenderer;
import de.datomino.util.geo.swing.renderer.PointRenderer;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;
import java.util.Collection;
import org.ktde.math.projection.Coordinate;
import org.ktde.swing.navigator.MouseManipulator;
import org.ktde.swing.navigator.NavigatorPanel;

public abstract class AbstractBucketNavigatorMouseManipulatorRenderer<S extends ValueChangeObservable, T extends ImmutableGeoObject>
extends AbstractGeometryNavigatorStaticRenderer<S, T>
implements GeoObjectBucketsChangeListener,
MouseManipulator {
    private GeoObjectBucketsModel<S, T> bucketsModel;
    private Collection<S> hover;
    private MouseEvent pressedMouseEvent;
    private NavigatorPanel navigatorPanel;
    private Coordinate mouseNow;

    public AbstractBucketNavigatorMouseManipulatorRenderer(String name, GeoObjectBucketsModel<S, T> bucketsModel, AreaRenderer<?, S> areaRenderer, LineRenderer<?, S> lineRenderer, PointRenderer<?, S> pointRenderer, GeomExtractor<S, T> geomExtractor, NavigatorPanel navigatorPanel) {
        super(name, areaRenderer, lineRenderer, pointRenderer, geomExtractor);
        this.navigatorPanel = navigatorPanel;
        this.bucketsModel = bucketsModel;
        this.bucketsModel.addGeoObjectBucketsChangeListener(this);
    }

    public AbstractBucketNavigatorMouseManipulatorRenderer(String name, GeoObjectBucketsModel<S, T> bucketsModel, double minUpp, double maxUpp, AreaRenderer<?, S> areaRenderer, LineRenderer<?, S> lineRenderer, PointRenderer<?, S> pointRenderer, GeomExtractor<S, T> geomExtractor, NavigatorPanel navigatorPanel) {
        super(name, minUpp, maxUpp, areaRenderer, lineRenderer, pointRenderer, geomExtractor);
        this.navigatorPanel = navigatorPanel;
        this.bucketsModel = bucketsModel;
        this.bucketsModel.addGeoObjectBucketsChangeListener(this);
    }

    public GeoObjectBucketsModel<S, T> getBucketsModel() {
        return this.bucketsModel;
    }

    public void setBucketsModel(GeoObjectBucketsModel<S, T> bucketsModel) {
        this.bucketsModel = bucketsModel;
    }

    @Override
    protected Collection<S> getGeometries(Coordinate bottomLeft, Coordinate topRight, double upp) {
        return this.bucketsModel.findObjects(bottomLeft, topRight);
    }

    @Override
    public void geoBucketsChanged(GeoObjectBucketsChangedEvent e) {
        this.callRepaint();
    }

    @Override
    public void close() {
        super.close();
        this.bucketsModel.clear();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!this.checkUpp()) {
            return;
        }
        if (this.pressedMouseEvent != null) {
            this.mouseReleased(e);
        }
        this.mouseNow = this.createCoordinateForPixel(e.getX(), e.getY());
        Collection<S> underMouse = this.bucketsModel.findObjects(this.mouseNow, this.getMindistForHover(e.getX(), e.getY()));
        if (!underMouse.isEmpty()) {
            if (!CollectionUtil.isEqualsCollection(this.hover, underMouse)) {
                this.hover = underMouse;
            }
            this.navigatorPanel.repaint(10L);
        } else if (this.hover != null) {
            this.hover = null;
            this.navigatorPanel.repaint(10L);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.checkUpp()) {
            return;
        }
        this.pressedMouseEvent = e;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.hover != null) {
            this.hover = null;
            this.navigatorPanel.repaint(10L);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
    }

    private double getMindistForHover(int x, int y) {
        return 5.0 * this.navigatorPanel.getUpp();
    }

    private boolean checkUpp() {
        return super.isActive() && super.getMaxUpp() >= this.navigatorPanel.getScaledUpp();
    }

    private Coordinate createCoordinateForPixel(int x, int y) {
        Point2D.Double point = this.navigatorPanel.getReal(new Point2D.Double(x, y));
        return this.navigatorPanel.getCoordinateFactory().createCoordinate(point.x, point.y);
    }

    protected Collection<S> getHover() {
        return this.hover;
    }

    protected Coordinate getMouseNow() {
        return this.mouseNow;
    }
}

