/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.geo.model.time;

import de.datomino.util.geo.model.time.TimeRange;
import de.datomino.util.time.TimeUtil;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.ktde.util.datatypes.Tupel;

public class TimeRangeList {
    private List<TimeRange> timeRanges = new LinkedList<TimeRange>();

    public TimeRangeList() {
    }

    public TimeRangeList(TimeRange currentTimeRange) {
        this.timeRanges.add(currentTimeRange);
    }

    public boolean coversTimeRange(TimeRange currentTimeRange) {
        if (currentTimeRange == null) {
            return false;
        }
        Date start = currentTimeRange.getStart();
        Date end = currentTimeRange.getEnd();
        if (end.before(start)) {
            return false;
        }
        for (TimeRange timeRange : this.timeRanges) {
            if (timeRange == null) continue;
            Date tStart = timeRange.getStart();
            boolean sameDay = TimeUtil.isSameDay(start, tStart);
            if (!sameDay && start.before(tStart)) {
                return false;
            }
            Date tEnd = timeRange.getEnd();
            sameDay = TimeUtil.isSameDay(end, tEnd);
            if (!sameDay && !end.before(tEnd)) continue;
            return true;
        }
        return false;
    }

    public TimeRangeList addTimeRange(TimeRange currentTimeRange) {
        if (currentTimeRange == null) {
            return this;
        }
        Date start = currentTimeRange.getStart();
        Date end = currentTimeRange.getEnd();
        if (end.after(start)) {
            if (this.timeRanges.isEmpty()) {
                this.timeRanges.add(currentTimeRange);
            } else {
                TimeRange innerStart = this.findTimeRangeForDate(start);
                TimeRange innerEnd = this.findTimeRangeForDate(end);
                Tupel<TimeRange, TimeRange> betweenStart = null;
                if (innerStart == null) {
                    betweenStart = this.findBetweenTimeRangeForDate(start);
                }
                Tupel<TimeRange, TimeRange> betweenEnd = null;
                if (innerEnd == null) {
                    betweenEnd = this.findBetweenTimeRangeForDate(end);
                }
                if (innerStart != null && innerEnd != null) {
                    this.mergeTimeRanges(innerStart, innerEnd);
                } else if (innerStart == null && innerEnd != null) {
                    this.mergeTimeRanges(start, betweenStart, innerEnd);
                } else if (innerStart != null && innerEnd == null) {
                    this.mergeTimeRanges(end, innerStart, betweenEnd);
                } else {
                    this.mergeTimeRanges(start, end, betweenStart, betweenEnd);
                }
                this.flatTimeRanges();
            }
        }
        return this;
    }

    private void flatTimeRanges() {
        if (!this.timeRanges.isEmpty()) {
            LinkedList<TimeRange> newList = new LinkedList<TimeRange>();
            Iterator<TimeRange> iter = this.timeRanges.iterator();
            TimeRange pred = iter.next();
            while (iter.hasNext()) {
                TimeRange succ = iter.next();
                if (TimeUtil.isSameDay(pred.getEnd(), succ.getStart())) {
                    pred = new TimeRange(pred.getStart(), succ.getEnd());
                    continue;
                }
                newList.add(pred);
                pred = succ;
            }
            newList.add(pred);
            this.timeRanges = newList;
        }
    }

    private void mergeTimeRanges(Date start, Date end, Tupel<TimeRange, TimeRange> betweenStart, Tupel<TimeRange, TimeRange> betweenEnd) {
        int step = 0;
        LinkedList<TimeRange> newList = new LinkedList<TimeRange>();
        for (TimeRange timeRange : this.timeRanges) {
            switch (step) {
                case 0: {
                    if (timeRange == betweenStart.getElement2()) {
                        step = 1;
                        break;
                    }
                    newList.add(timeRange);
                    break;
                }
                case 1: {
                    if (timeRange != betweenEnd.getElement1()) break;
                    newList.add(new TimeRange(start, end));
                    step = 2;
                    break;
                }
                case 2: {
                    newList.add(timeRange);
                }
            }
        }
    }

    private void mergeTimeRanges(Date end, TimeRange innerStart, Tupel<TimeRange, TimeRange> betweenEnd) {
        int step = 0;
        LinkedList<TimeRange> newList = new LinkedList<TimeRange>();
        for (TimeRange timeRange : this.timeRanges) {
            switch (step) {
                case 0: {
                    if (timeRange == innerStart) {
                        step = 1;
                        break;
                    }
                    newList.add(timeRange);
                    break;
                }
                case 1: {
                    if (timeRange != betweenEnd.getElement1()) break;
                    newList.add(new TimeRange(innerStart.getStart(), end));
                    step = 2;
                    break;
                }
                case 2: {
                    newList.add(timeRange);
                }
            }
        }
        this.timeRanges = newList;
    }

    private void mergeTimeRanges(Date start, Tupel<TimeRange, TimeRange> betweenStart, TimeRange innerEnd) {
        int step = 0;
        LinkedList<TimeRange> newList = new LinkedList<TimeRange>();
        for (TimeRange timeRange : this.timeRanges) {
            switch (step) {
                case 0: {
                    if (timeRange == betweenStart.getElement2()) {
                        step = 1;
                        break;
                    }
                    newList.add(timeRange);
                    break;
                }
                case 1: {
                    if (timeRange != innerEnd) break;
                    newList.add(new TimeRange(start, innerEnd.getEnd()));
                    step = 2;
                    break;
                }
                case 2: {
                    newList.add(timeRange);
                }
            }
        }
        this.timeRanges = newList;
    }

    private void mergeTimeRanges(TimeRange innerStart, TimeRange innerEnd) {
        if (innerStart != innerEnd) {
            LinkedList<TimeRange> newList = new LinkedList<TimeRange>();
            int step = 0;
            for (TimeRange timeRange : this.timeRanges) {
                switch (step) {
                    case 0: {
                        if (innerStart == timeRange) {
                            step = 1;
                            break;
                        }
                        newList.add(timeRange);
                        break;
                    }
                    case 1: {
                        if (innerEnd != timeRange) break;
                        newList.add(new TimeRange(innerStart.getStart(), innerEnd.getEnd()));
                        step = 2;
                        break;
                    }
                    case 2: {
                        newList.add(timeRange);
                    }
                }
            }
            this.timeRanges = newList;
        }
    }

    private Tupel<TimeRange, TimeRange> findBetweenTimeRangeForDate(Date date) {
        if (this.timeRanges.isEmpty()) {
            return new Tupel<Object, Object>(null, null);
        }
        Iterator<TimeRange> iter = this.timeRanges.iterator();
        TimeRange pred = iter.next();
        Date pStart = pred.getStart();
        if (date.before(pStart)) {
            return new Tupel<Object, TimeRange>(null, pred);
        }
        while (iter.hasNext()) {
            TimeRange succ = iter.next();
            if (date.before(succ.getStart())) {
                return new Tupel<TimeRange, TimeRange>(pred, succ);
            }
            pred = succ;
        }
        return new Tupel<TimeRange, Object>(pred, null);
    }

    private TimeRange findTimeRangeForDate(Date start) {
        for (TimeRange timeRange : this.timeRanges) {
            if (timeRange == null || !TimeUtil.isSameDay(start, timeRange.getStart()) && !TimeUtil.isSameDay(start, timeRange.getEnd()) && (!start.after(timeRange.getStart()) || !start.before(timeRange.getEnd()))) continue;
            return timeRange;
        }
        return null;
    }
}

