/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.geo.model;

import de.datomino.util.ValueChangeObservable;
import de.datomino.util.geo.ImmutableGeoObject;
import de.datomino.util.geo.model.AbstractGeoObjectBucketsModel;
import de.datomino.util.geo.model.GeoObjectBucketsChangedEvent;
import de.datomino.util.geo.model.GeoObjectBucketsFilter;
import de.datomino.util.geo.model.GeoObjectBucketsModel;
import de.datomino.util.geo.model.GeomExtractor;
import de.datomino.util.swing.blocking.BusyHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ktde.math.projection.CoordinateFactory;

public class StaticGeoObjectBucketsModel<S extends ValueChangeObservable, T extends ImmutableGeoObject>
extends AbstractGeoObjectBucketsModel<S, T> {
    private Set<S> staticObjects = new HashSet<S>();
    private Map<GeoObjectBucketsFilter<S>, GeoObjectBucketsModel<S, T>> subBuckets = new HashMap<GeoObjectBucketsFilter<S>, GeoObjectBucketsModel<S, T>>();

    public StaticGeoObjectBucketsModel(GeomExtractor<S, T> geomExtractor, CoordinateFactory coordinateFactory) {
        super(geomExtractor, coordinateFactory, null);
    }

    @Override
    protected Collection<Collection<S>> findBuckets(double minx0, double maxx0, double maxy0, double miny0) {
        Set<S> lStaticObjects = this.staticObjects;
        return Collections.singleton(lStaticObjects);
    }

    @Override
    public boolean contains(S model) {
        return this.staticObjects.contains(model);
    }

    public void addGeoObjects(Collection<? extends S> geoObjects) {
        this.staticObjects.addAll(geoObjects);
        this.fireGeoObjectBucketsChangedEvent(new GeoObjectBucketsChangedEvent(this));
    }

    @Override
    public void clear() {
        this.staticObjects.clear();
        this.subBuckets.clear();
        this.fireGeoObjectBucketsChangedEvent(new GeoObjectBucketsChangedEvent(this));
    }

    @Override
    public void setBusyHandler(BusyHandler busyHandler) {
    }

    @Override
    public void addGeom(S model) {
        this.staticObjects.add(model);
        this.fireGeoObjectBucketsChangedEvent(new GeoObjectBucketsChangedEvent(this));
    }

    @Override
    public void addAll(Collection<? extends S> models) {
        this.addGeoObjects(models);
    }

    @Override
    public void remove(S model) {
        this.staticObjects.remove(model);
        this.fireGeoObjectBucketsChangedEvent(new GeoObjectBucketsChangedEvent(this));
    }
}

