/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.geo.model;

import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.model.GeomExtractor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.ktde.math.helper.ComputeTrigonometrics;

public class LinestringExtractorAtPointComparator<T>
implements Comparator<T> {
    private ImmutablePoint point;
    private GeomExtractor<T, ImmutableLineString> extractor;

    public LinestringExtractorAtPointComparator(ImmutablePoint point, GeomExtractor<T, ImmutableLineString> extractor) {
        this.point = point;
        this.extractor = extractor;
    }

    @Override
    public int compare(T arg1, T arg2) {
        List<ImmutablePoint> coords1 = this.extractor.getGeom(arg1).getCoordinates();
        List<ImmutablePoint> coords2 = this.extractor.getGeom(arg2).getCoordinates();
        if (!coords1.get(0).equals(this.point)) {
            coords1 = new ArrayList<ImmutablePoint>(coords1);
            Collections.reverse(coords1);
        }
        if (!coords2.get(0).equals(this.point)) {
            coords2 = new ArrayList<ImmutablePoint>(coords2);
            Collections.reverse(coords2);
        }
        double xs = coords1.get(0).getX();
        double ys = coords1.get(0).getY();
        double x1 = coords1.get(1).getX();
        double y1 = coords1.get(1).getY();
        double x2 = coords2.get(1).getX();
        double y2 = coords2.get(1).getY();
        double angle1 = ComputeTrigonometrics.normalizeAngle(xs, ys, x1, y1);
        double angle2 = ComputeTrigonometrics.normalizeAngle(xs, ys, x2, y2);
        return Double.valueOf(angle1).compareTo(angle2);
    }
}

