/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.geo.model;

import com.vividsolutions.jts.geom.IntersectionMatrix;
import com.vividsolutions.jts.geom.TopologyException;
import de.datomino.util.ValueChangeObservable;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.collection.Transformer;
import de.datomino.util.geo.ImmutableEnvelope;
import de.datomino.util.geo.ImmutableGeoObject;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutableLineKind;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.ImmutablePolygon;
import de.datomino.util.geo.ImmutablePolygonKind;
import de.datomino.util.geo.MarkerMode;
import de.datomino.util.geo.model.GeoObjectBucketsChangeListener;
import de.datomino.util.geo.model.GeoObjectBucketsChangedEvent;
import de.datomino.util.geo.model.GeoObjectBucketsModel;
import de.datomino.util.geo.model.GeomExtractor;
import de.datomino.util.geo.util.GeoUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.swing.event.EventListenerList;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.util.datatypes.Tupel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGeoObjectBucketsModel<S extends ValueChangeObservable, T extends ImmutableGeoObject>
implements GeoObjectBucketsModel<S, T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractGeoObjectBucketsModel.class);
    private EventListenerList listenerList;
    private CoordinateFactory coordinateFactory;
    private GeomExtractor<S, T> geomExtractor;
    private ImmutablePolygon maxEnvelope;

    public AbstractGeoObjectBucketsModel(GeomExtractor<S, T> geomExtractor, CoordinateFactory coordinateFactory, ImmutablePolygon maxEnvelope) {
        this.geomExtractor = geomExtractor;
        this.coordinateFactory = coordinateFactory;
        this.maxEnvelope = maxEnvelope;
        this.listenerList = new EventListenerList();
    }

    @Override
    public T extractGeom(S model) {
        if (model == null) {
            return null;
        }
        return this.geomExtractor.getGeom(model);
    }

    @Override
    public GeomExtractor<S, T> getGeomExtractor() {
        return this.geomExtractor;
    }

    @Override
    public void removeGeoObjectBucketsChangeListener(GeoObjectBucketsChangeListener listener) {
        this.listenerList.remove(GeoObjectBucketsChangeListener.class, listener);
    }

    @Override
    public void addGeoObjectBucketsChangeListener(GeoObjectBucketsChangeListener listener) {
        this.listenerList.add(GeoObjectBucketsChangeListener.class, listener);
    }

    protected void fireGeoObjectBucketsChangedEvent(GeoObjectBucketsChangedEvent e) {
        if (e == null) {
            e = new GeoObjectBucketsChangedEvent(this);
        }
        GeoObjectBucketsChangeListener[] listeners = (GeoObjectBucketsChangeListener[])this.listenerList.getListeners(GeoObjectBucketsChangeListener.class);
        for (int i = 0; i < listeners.length; i += 2) {
            listeners[i].geoBucketsChanged(e);
        }
    }

    @Override
    public Collection<S> findObjects(ImmutablePoint bottomLeft, ImmutablePoint topRight, MarkerMode markerMode) {
        return this.findObjects(bottomLeft.getCoordinate(), topRight.getCoordinate(), markerMode);
    }

    @Override
    public Collection<S> findObjects(ImmutablePoint bottomLeft, ImmutablePoint topRight) {
        return this.findObjects(bottomLeft, topRight, MarkerMode.RECTANGLE_CROSSES);
    }

    @Override
    public Collection<S> findObjects(Coordinate bottomLeft, Coordinate topRight) {
        return this.findObjects(bottomLeft, topRight, MarkerMode.RECTANGLE_CROSSES);
    }

    @Override
    public Collection<S> findObjects(Coordinate bottomLeft, Coordinate topRight, MarkerMode markerMode) {
        return this.findObjects(bottomLeft, topRight, null, markerMode);
    }

    @Override
    public Collection<S> findObjects(ImmutableEnvelope envelope) {
        return this.findObjects(envelope.getBottomLeft(), envelope.getTopRight(), MarkerMode.RECTANGLE_CROSSES);
    }

    @Override
    public Collection<S> findObjects(Coordinate bottomLeft, Coordinate topRight, List<Coordinate> tracePoints, MarkerMode markerMode) {
        Coordinate bottomRight;
        GeoUtils.SearchPolygon searchPolygon = GeoUtils.createSearchPolygon(bottomLeft, topRight, markerMode, tracePoints, this.getCoordinateFactory(), false);
        double minx0 = searchPolygon.getMinx();
        double maxx0 = searchPolygon.getMaxx();
        double maxy0 = searchPolygon.getMaxy();
        double miny0 = searchPolygon.getMiny();
        double distance0 = searchPolygon.getDistance();
        ImmutablePolygonKind searchPoly = searchPolygon.getPolygon();
        double cx0 = searchPolygon.getCenterX();
        double cy0 = searchPolygon.getCenterY();
        Coordinate topLeft = this.getCoordinateFactory().createCoordinate(minx0, maxy0);
        if (!GeoUtils.isInEnvelope(topLeft, bottomRight = this.getCoordinateFactory().createCoordinate(maxx0, miny0), this.maxEnvelope, 0.0)) {
            return Collections.EMPTY_SET;
        }
        Collection<Collection<S>> buckets = this.findBuckets(minx0, maxx0, maxy0, miny0);
        HashSet<ValueChangeObservable> result = new HashSet<ValueChangeObservable>();
        for (Collection<S> bucket : buckets) {
            block11: for (ValueChangeObservable model : bucket) {
                T extract = this.extractGeom(model);
                if (extract == null) continue;
                ImmutableGeoObject geom = extract.getTransformed(this.coordinateFactory);
                double minx = geom.getMinX();
                double miny = geom.getMinY();
                double maxx = geom.getMaxX();
                double maxy = geom.getMaxY();
                if (!(minx <= maxx0) || !(maxx >= minx0) || !(miny <= maxy0) || !(maxy >= miny0)) continue;
                switch (markerMode) {
                    case RECTANGLE_CROSSES: {
                        if (searchPoly != null && !searchPoly.intersects(geom)) break;
                        result.add(model);
                        break;
                    }
                    case RECTANGLE_WITHIN: {
                        if (!(minx >= minx0) || !(maxx <= maxx0) || !(miny >= miny0) || !(maxy <= maxy0)) break;
                        result.add(model);
                        break;
                    }
                    case CIRCLE_CROSSES: {
                        double minDistance = geom.distance(ImmutableGeoObjectFactory.createImmutablePoint(this.coordinateFactory.createCoordinate(cx0, cy0)));
                        if (!(minDistance <= distance0)) break;
                        result.add(model);
                        break;
                    }
                    case CIRCLE_WITHIN: {
                        double minDistance = geom.distance(ImmutableGeoObjectFactory.createImmutablePoint(this.coordinateFactory.createCoordinate(cx0, cy0)));
                        if (!(minDistance < distance0)) break;
                        List<ImmutablePoint> coordlist = geom.getCoordinates();
                        boolean add = true;
                        for (ImmutablePoint immutablePoint : coordlist) {
                            minDistance = immutablePoint.distance(ImmutableGeoObjectFactory.createImmutablePoint(this.coordinateFactory.createCoordinate(cx0, cy0)));
                            if (!(minDistance > distance0)) continue;
                            add = false;
                            break;
                        }
                        if (!add) continue block11;
                        result.add(model);
                        break;
                    }
                    case FREEHAND_WITHIN: {
                        if (searchPoly == null || !searchPoly.contains(geom)) break;
                        result.add(model);
                        break;
                    }
                    case FREEHAND_HALF: {
                        boolean add;
                        if (searchPoly == null) break;
                        try {
                            if (searchPoly.contains(geom)) {
                                result.add(model);
                                break;
                            }
                            ImmutableGeoObject intergeom = geom.intersection(searchPoly);
                            add = false;
                            if (geom instanceof ImmutablePolygonKind && intergeom instanceof ImmutablePolygonKind) {
                                double totalGeomArea = geom.getArea();
                                add = intergeom.getArea() > totalGeomArea / 2.0;
                            } else if (geom instanceof ImmutableLineKind && intergeom instanceof ImmutableLineKind) {
                                double totalLength = geom.getLength();
                                boolean bl = add = intergeom.getLength() > totalLength / 2.0;
                            }
                            if (!add) continue block11;
                            result.add(model);
                        }
                        catch (Exception e) {
                            LOGGER.debug("Could not intersect geometries", e);
                        }
                        break;
                    }
                }
            }
        }
        return result;
    }

    @Override
    public Collection<S> findObjects(ImmutablePoint point, double minDist) {
        return this.findObjects(point.getCoordinate(), minDist);
    }

    @Override
    public Collection<S> findObjects(Coordinate coordinate, double minDist) {
        return this.findObjects(coordinate, minDist, false);
    }

    @Override
    public Collection<S> findObjects(ImmutablePoint point, double minDist, boolean fullCover) {
        return this.findObjects(point.getCoordinate(), minDist, fullCover);
    }

    @Override
    public Collection<Tupel<S, Double>> findObjectsWithDist(Coordinate coordinate, double minDist) {
        return this.findObjectsWithDist(coordinate, minDist, false);
    }

    @Override
    public Collection<S> findObjects(Coordinate coordinate, double minDist, boolean fullCover) {
        Collection<Tupel<S, Double>> col = this.findObjectsWithDist(coordinate, minDist, fullCover);
        ArrayList result = new ArrayList(col.size());
        CollectionUtil.transform(col, result, new Transformer<Tupel<S, Double>, S>(){

            @Override
            public S transform(Tupel<S, Double> t) {
                return (ValueChangeObservable)t.getElement1();
            }
        });
        return result;
    }

    private Collection<Tupel<S, Double>> findObjectsWithDist(Coordinate coordinate, double minDist, boolean fullCover) {
        minDist = minDist / coordinate.getFactory().getRefScale() * this.coordinateFactory.getRefScale();
        Coordinate cCorrect = this.coordinateFactory.createCoordinate(coordinate);
        ImmutablePoint pointCorrect = ImmutableGeoObjectFactory.createImmutablePoint(cCorrect);
        Coordinate cCorrectRadius = this.coordinateFactory.createCoordinate(cCorrect.getX(), cCorrect.getY() + minDist);
        Collection<S> between = this.findObjects(cCorrect, cCorrectRadius, fullCover ? MarkerMode.CIRCLE_WITHIN : MarkerMode.CIRCLE_CROSSES);
        ArrayList<Tupel<S, Double>> sortedSet = new ArrayList<Tupel<S, Double>>(between.size());
        for (ValueChangeObservable s : between) {
            double dist;
            ImmutableGeoObject geom = this.extractGeom(s).getTransformed(this.coordinateFactory);
            boolean contains = false;
            try {
                contains = geom.contains(pointCorrect);
            }
            catch (TopologyException topologyException) {
                // empty catch block
            }
            double d = dist = contains ? 0.0 : geom.distance(pointCorrect);
            if (!(geom.distance(pointCorrect) <= minDist)) continue;
            sortedSet.add(new Tupel<ValueChangeObservable, Double>(s, dist));
        }
        Comparator comparator = new Comparator<Tupel<S, Double>>(){

            @Override
            public int compare(Tupel<S, Double> t1, Tupel<S, Double> t2) {
                return t1.getElement2().compareTo(t2.getElement2());
            }
        };
        Collections.sort(sortedSet, comparator);
        return sortedSet;
    }

    @Override
    public Collection<S> findObjects(ImmutablePolygonKind immutablePolygonKind) {
        Collection<S> ss = this.findObjects(immutablePolygonKind.getEnvelope());
        ArrayList<ValueChangeObservable> filtered = new ArrayList<ValueChangeObservable>(ss.size());
        for (ValueChangeObservable s : ss) {
            T extract = this.extractGeom(s);
            IntersectionMatrix relate = immutablePolygonKind.relate((ImmutableGeoObject)extract);
            if (relate.isDisjoint()) continue;
            filtered.add(s);
        }
        return filtered;
    }

    protected abstract Collection<Collection<S>> findBuckets(double var1, double var3, double var5, double var7);

    public CoordinateFactory getCoordinateFactory() {
        return this.coordinateFactory;
    }

    @Override
    public T getGeom(S object) {
        return this.extractGeom(object);
    }
}

