/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.geo;

import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import de.datomino.util.geo.AbstractImmutableValidGeoObject;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.ImmutablePolygonKind;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.ktde.math.projection.CoordinateFactory;

public class ImmutablePolygon
extends AbstractImmutableValidGeoObject<ImmutablePolygon, Polygon>
implements ImmutablePolygonKind {
    private transient ImmutableLineString exteriorRing;
    private transient List<ImmutableLineString> interiorRings;

    protected ImmutablePolygon(Polygon geometry, CoordinateFactory coordinateFactory) {
        super(geometry, coordinateFactory);
    }

    public ImmutableLineString getShell() {
        if (this.exteriorRing == null) {
            this.exteriorRing = new ImmutableLineString(((Polygon)this.getGeometry()).getExteriorRing(), this.getCoordinateFactory());
        }
        return this.exteriorRing;
    }

    @Override
    public ImmutablePoint getAnyPoint() {
        return this.getShell().getAnyPoint();
    }

    @Override
    public List<ImmutablePoint> getCoordinates() {
        LinkedList<ImmutablePoint> points = new LinkedList<ImmutablePoint>();
        points.addAll(this.getShell().getCoordinates());
        for (ImmutableLineString part : this.getHoles()) {
            points.addAll(part.getCoordinates());
        }
        return points;
    }

    public List<ImmutableLineString> getHoles() {
        if (this.interiorRings == null) {
            int holeCount = ((Polygon)this.getGeometry()).getNumInteriorRing();
            ArrayList<ImmutableLineString> interiorRings = new ArrayList<ImmutableLineString>(holeCount);
            for (int i = 0; i < holeCount; ++i) {
                LineString hole = ((Polygon)this.getGeometry()).getInteriorRingN(i);
                interiorRings.add(new ImmutableLineString(hole, this.getCoordinateFactory()));
            }
            this.interiorRings = Collections.unmodifiableList(interiorRings);
        }
        return this.interiorRings;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ImmutablePolygon) {
            ImmutablePolygon other = (ImmutablePolygon)obj;
            return new EqualsBuilder().append(this.getShell(), other.getShell()).append(this.getHoles(), other.getHoles()).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.getShell()).append(this.getHoles()).toHashCode();
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder(this);
        int count = 0;
        toStringBuilder.append("Shell ");
        for (ImmutablePoint point : this.getShell().getCoordinates()) {
            toStringBuilder.append(Integer.toString(count), point);
            ++count;
        }
        for (ImmutableLineString hole : this.getHoles()) {
            count = 0;
            toStringBuilder.append("Hole ");
            for (ImmutablePoint point : hole.getCoordinates()) {
                toStringBuilder.append(Integer.toString(count), point);
                ++count;
            }
        }
        return toStringBuilder.toString();
    }
}

