/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.geo;

import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import de.datomino.util.geo.AbstractImmutableValidGeoObject;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutableLineKind;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.util.BasedPoint;
import de.datomino.util.geo.util.GeoUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.ktde.math.helper.ComputeTrigonometrics;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.util.conversions.IteratorIterable;
import org.ktde.util.datatypes.Tripel;
import org.ktde.util.datatypes.Tupel;

public class ImmutableLineString
extends AbstractImmutableValidGeoObject<ImmutableLineString, LineString>
implements ImmutableLineKind {
    private transient List<ImmutablePoint> points;

    protected ImmutableLineString(LineString lineString, CoordinateFactory coordinateFactory) {
        super(lineString, coordinateFactory);
    }

    @Override
    public List<ImmutablePoint> getCoordinates() {
        if (this.points == null) {
            int numPoints = ((LineString)this.getGeometry()).getNumPoints();
            ArrayList<ImmutablePoint> points = new ArrayList<ImmutablePoint>(numPoints);
            for (int i = 0; i < numPoints; ++i) {
                Point point = ((LineString)this.getGeometry()).getPointN(i);
                points.add(new ImmutablePoint(point, this.getCoordinateFactory()));
            }
            this.points = Collections.unmodifiableList(points);
        }
        return this.points;
    }

    @Override
    public ImmutablePoint getAnyPoint() {
        int numPoints = ((LineString)this.getGeometry()).getNumPoints();
        return this.getCoordinates().get(numPoints / 2);
    }

    public ImmutableLineString replacePoint(int index, ImmutablePoint newPoint) {
        newPoint = (ImmutablePoint)newPoint.getTransformed(this.getCoordinateFactory());
        GeometryFactory geometryFactory = new GeometryFactory();
        int numPoints = ((LineString)this.getGeometry()).getNumPoints();
        com.vividsolutions.jts.geom.Coordinate[] coordinates = new com.vividsolutions.jts.geom.Coordinate[numPoints];
        for (int i = 0; i < numPoints; ++i) {
            if (i == index) {
                coordinates[i] = ((Point)newPoint.getGeometry()).getCoordinate();
                continue;
            }
            Point point = ((LineString)this.getGeometry()).getPointN(i);
            coordinates[i] = point.getCoordinate();
        }
        return new ImmutableLineString(geometryFactory.createLineString(coordinates), this.getCoordinateFactory());
    }

    public Tupel<ImmutableLineString, Integer> insertPoint(ImmutablePoint point) {
        return this.insertPoint(point, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Tupel<ImmutableLineString, Integer> insertPoint(ImmutablePoint point, Double mindist) {
        Point cpoint;
        int j;
        point = (ImmutablePoint)point.getTransformed(this.getCoordinateFactory());
        GeometryFactory geometryFactory = new GeometryFactory();
        boolean ring = this.isRing();
        List<ImmutablePoint> points = this.getCoordinates();
        int c = points.size();
        if (mindist == null) {
            mindist = Double.MAX_VALUE;
        }
        int minindex = -1;
        block7: for (int i = 1; i < c; ++i) {
            Tripel<Double, ImmutablePoint, GeoUtils.Relation> rel = GeoUtils.getPointRelationDescription(point, points.get(i - 1), points.get(i), this.getCoordinateFactory());
            if (!(mindist > rel.getElement1())) continue;
            switch (rel.getElement3()) {
                case INTERVAL_BEFORE: {
                    if (ring || i != 1) break;
                    mindist = rel.getElement1();
                    minindex = 0;
                    break;
                }
                case INTERVAL_START: {
                    if (ring || i != 1) break;
                    mindist = rel.getElement1();
                    minindex = 0;
                    if (mindist != 0.0) break;
                    return null;
                }
                case INTERVAL_WITHIN: {
                    mindist = rel.getElement1();
                    minindex = i;
                    if (mindist != 0.0) break;
                    break block7;
                }
                case INTERVAL_END: {
                    mindist = rel.getElement1();
                    minindex = i;
                    if (mindist != 0.0 || i != c - 1) break;
                    return null;
                }
                case INTERVAL_AFTER: {
                    mindist = rel.getElement1();
                    minindex = i + 1;
                }
            }
        }
        if (minindex <= -1) {
            return null;
        }
        com.vividsolutions.jts.geom.Coordinate[] coordinates = new com.vividsolutions.jts.geom.Coordinate[c + (mindist > 0.0 ? 1 : 0)];
        int i = 0;
        for (j = 0; j < minindex; ++j) {
            cpoint = ((LineString)this.getGeometry()).getPointN(j);
            coordinates[i++] = cpoint.getCoordinate();
        }
        if (mindist > 0.0) {
            coordinates[i++] = ((Point)point.getGeometry()).getCoordinate();
        }
        j = minindex;
        while (j < c) {
            cpoint = ((LineString)this.getGeometry()).getPointN(j);
            coordinates[i++] = cpoint.getCoordinate();
            ++j;
        }
        return new Tupel<ImmutableLineString, Integer>(new ImmutableLineString(geometryFactory.createLineString(coordinates), this.getCoordinateFactory()), minindex);
    }

    private boolean isRing() {
        List<ImmutablePoint> points = this.getCoordinates();
        return points.get(0).equals(points.get(points.size() - 1));
    }

    public ImmutablePoint getStartPoint() {
        List<ImmutablePoint> points = this.getCoordinates();
        return points.get(0);
    }

    public ImmutablePoint getEndPoint() {
        List<ImmutablePoint> points = this.getCoordinates();
        return points.get(points.size() - 1);
    }

    public ImmutableLineString getMirror() {
        GeometryFactory geometryFactory = new GeometryFactory();
        int numPoints = ((LineString)this.getGeometry()).getNumPoints();
        com.vividsolutions.jts.geom.Coordinate[] coordinates = new com.vividsolutions.jts.geom.Coordinate[numPoints];
        for (int i = 0; i < numPoints; ++i) {
            Point point = ((LineString)this.getGeometry()).getPointN(i);
            coordinates[numPoints - (i + 1)] = point.getCoordinate();
        }
        return new ImmutableLineString(geometryFactory.createLineString(coordinates), this.getCoordinateFactory());
    }

    public boolean equals(Object obj) {
        if (obj instanceof ImmutableLineString) {
            ImmutableLineString other = (ImmutableLineString)obj;
            List<ImmutablePoint> thisPointList = this.getCoordinates();
            List<ImmutablePoint> otherPointList = other.getCoordinates();
            if (thisPointList.size() == otherPointList.size()) {
                Iterator<ImmutablePoint> thisPointIter = thisPointList.iterator();
                Iterator<ImmutablePoint> otherPointIter = otherPointList.iterator();
                while (thisPointIter.hasNext()) {
                    if (thisPointIter.next().equals(otherPointIter.next())) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        for (ImmutablePoint point : this.getCoordinates()) {
            hashCodeBuilder.append(point);
        }
        return hashCodeBuilder.toHashCode();
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder(this);
        int count = 0;
        for (ImmutablePoint point : this.getCoordinates()) {
            toStringBuilder.append(Integer.toString(count), point);
            ++count;
        }
        return toStringBuilder.toString();
    }

    public ImmutablePoint getBasePoint(ImmutablePoint point, Double mindist) {
        List<ImmutablePoint> points = this.getCoordinates();
        int c = points.size();
        if (mindist == null) {
            mindist = Double.MAX_VALUE;
        }
        ImmutablePoint result = null;
        for (int i = 1; i < c; ++i) {
            Tripel<Double, ImmutablePoint, GeoUtils.Relation> rel = GeoUtils.getPointRelationDescription(point, points.get(i - 1), points.get(i), this.getCoordinateFactory());
            if (!(mindist > rel.getElement1())) continue;
            mindist = rel.getElement1();
            result = rel.getElement2();
        }
        return result;
    }

    public Tupel<ImmutableLineString, ImmutableLineString> cutAtPoint(ImmutablePoint point) {
        point = (ImmutablePoint)point.getTransformed(this.getCoordinateFactory());
        GeometryFactory geometryFactory = new GeometryFactory();
        BasedPoint basedPoint = GeoUtils.getPointRelationDescription(this, point);
        List<ImmutablePoint> points = this.getCoordinates();
        double lengthtotal = 0.0;
        double baselength = basedPoint.getDistanceOnBaseline();
        LinkedList<ImmutablePoint> points1 = new LinkedList<ImmutablePoint>();
        LinkedList<ImmutablePoint> points2 = new LinkedList<ImmutablePoint>();
        ImmutablePoint lastPoint = points.get(0);
        points1.add(lastPoint);
        IteratorIterable<ImmutablePoint> iter = new IteratorIterable<ImmutablePoint>(points.listIterator(1));
        for (ImmutablePoint curPoint : iter) {
            if ((lengthtotal += lastPoint.distance(curPoint)) == baselength) {
                points1.add(point);
                points2.add(point);
                break;
            }
            if (lengthtotal > baselength) {
                points1.add(point);
                points2.add(point);
                points2.add(curPoint);
                break;
            }
            points1.add(curPoint);
            lastPoint = curPoint;
        }
        for (ImmutablePoint curPoint : iter) {
            points2.add(curPoint);
        }
        if (points2.size() < 2 && points2.size() > 0) {
            points2.add((ImmutablePoint)points2.get(0));
        }
        com.vividsolutions.jts.geom.Coordinate[] coordinates1 = new com.vividsolutions.jts.geom.Coordinate[points1.size()];
        com.vividsolutions.jts.geom.Coordinate[] coordinates2 = new com.vividsolutions.jts.geom.Coordinate[points2.size()];
        int i = 0;
        for (ImmutablePoint curPoint : points1) {
            coordinates1[i++] = ((Point)curPoint.getGeometry()).getCoordinate();
        }
        i = 0;
        for (ImmutablePoint curPoint : points2) {
            coordinates2[i++] = ((Point)curPoint.getGeometry()).getCoordinate();
        }
        return new Tupel<ImmutableLineString, ImmutableLineString>(new ImmutableLineString(geometryFactory.createLineString(coordinates1), this.getCoordinateFactory()), points2.isEmpty() ? null : new ImmutableLineString(geometryFactory.createLineString(coordinates2), this.getCoordinateFactory()));
    }

    public Double getSphericalLength() {
        ArrayList<Coordinate> coords = new ArrayList<Coordinate>();
        for (ImmutablePoint point : this.getCoordinates()) {
            coords.add(point.getCoordinate());
        }
        return ComputeTrigonometrics.getSphericalLength(coords);
    }

    public ImmutableLineString shortenFromEnd(double percentage) {
        return this.shorten(percentage, true, true);
    }

    public ImmutableLineString shortenFromStart(double percentage) {
        return this.shorten(percentage, true, false);
    }

    public ImmutableLineString shortenFromEnd(double len, boolean percentage) {
        return this.shorten(len, percentage, true);
    }

    public ImmutableLineString shortenFromStart(double len, boolean percentage) {
        return this.shorten(len, percentage, false);
    }

    private ImmutableLineString shorten(double len, boolean percentage, boolean fromEnd) {
        double partDistance;
        if (len <= 0.0) {
            return this;
        }
        double currentLength = this.getLength();
        if (currentLength == 0.0) {
            return this;
        }
        double lengthToCut = percentage ? currentLength / 100.0 * len : (currentLength > len ? len : currentLength);
        LinkedList<ImmutablePoint> points = new LinkedList<ImmutablePoint>(this.getCoordinates());
        if (fromEnd) {
            Collections.reverse(points);
        }
        Iterator iter = points.iterator();
        ImmutablePoint succ = (ImmutablePoint)iter.next();
        ImmutablePoint pred = null;
        Coordinate newStart = null;
        while (lengthToCut > 0.0 && lengthToCut != (partDistance = succ.distance(pred = (ImmutablePoint)iter.next()))) {
            if (lengthToCut < partDistance) {
                double x = pred.getX() - succ.getX();
                double y = pred.getY() - succ.getY();
                double length = Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0));
                double nx = x / length * lengthToCut;
                double ny = y / length * lengthToCut;
                newStart = new Coordinate(succ.getCoordinateFactory(), succ.getX() + nx, succ.getY() + ny);
                break;
            }
            lengthToCut -= partDistance;
            succ = pred;
        }
        LinkedList<Coordinate> newCoords = new LinkedList<Coordinate>();
        if (newStart != null) {
            newCoords.add(newStart);
        }
        newCoords.add(pred.getCoordinate());
        while (iter.hasNext()) {
            newCoords.add(((ImmutablePoint)iter.next()).getCoordinate());
        }
        if (fromEnd) {
            Collections.reverse(newCoords);
        }
        return ImmutableGeoObjectFactory.createImmutableLineString(newCoords);
    }

    public ImmutableLineString extendPoint(ImmutablePoint mousePoint, boolean start) {
        GeometryFactory geometryFactory = new GeometryFactory();
        int numPoints = ((LineString)this.getGeometry()).getNumPoints();
        com.vividsolutions.jts.geom.Coordinate[] coordinates = new com.vividsolutions.jts.geom.Coordinate[numPoints + 1];
        int i = 0;
        if (start) {
            coordinates[i++] = ((Point)mousePoint.getGeometry()).getCoordinate();
        }
        for (int j = 0; j < numPoints; ++j) {
            Point point = ((LineString)this.getGeometry()).getPointN(j);
            coordinates[i++] = point.getCoordinate();
        }
        if (!start) {
            coordinates[i++] = ((Point)mousePoint.getGeometry()).getCoordinate();
        }
        return new ImmutableLineString(geometryFactory.createLineString(coordinates), this.getCoordinateFactory());
    }

    public ImmutablePoint getNormalPoint(ImmutablePoint basePoint, boolean left, double length) {
        BasedPoint basedPoint = GeoUtils.getPointRelationDescription(this, basePoint);
        double baselength = basedPoint.getDistanceOnBaseline();
        return this.getNormalPoint(baselength, left, length);
    }

    public ImmutablePoint getNormalPoint(double baselength, boolean left, double length) {
        List<ImmutablePoint> points = this.getCoordinates();
        int c = points.size();
        ImmutablePoint point1 = points.get(0);
        double x1 = point1.getX();
        double y1 = point1.getY();
        double totLength = 0.0;
        double xs = x1;
        double ys = y1;
        double x2 = x1;
        double y2 = y1;
        for (int i = 1; i < c; ++i) {
            ImmutablePoint point2 = points.get(i);
            x2 = point2.getX();
            y2 = point2.getY();
            double lineLength = Math.sqrt(Math.pow(x2 - x1, 2.0) + Math.pow(y2 - y1, 2.0));
            if ((totLength += lineLength) >= baselength || i == c - 1) {
                double factorLinear = 1.0 - (totLength - baselength) / lineLength;
                xs = x1 + factorLinear * (x2 - x1);
                ys = y1 + factorLinear * (y2 - y1);
                break;
            }
            x1 = x2;
            y1 = y2;
        }
        return this.getNormalPoint(left, length, x1, y1, x2, y2, xs, ys);
    }

    public ImmutableLineString getNormal(boolean left, double length) {
        ImmutablePoint pointa;
        List<ImmutablePoint> points = this.getCoordinates();
        ImmutablePoint point1 = points.get(points.size() / 2 - 1);
        ImmutablePoint point2 = points.get(points.size() / 2);
        double x1 = point1.getX();
        double y1 = point1.getY();
        double x2 = point2.getX();
        double y2 = point2.getY();
        if (points.size() % 2 == 0) {
            pointa = ImmutableGeoObjectFactory.createImmutablePoint(this.getCoordinateFactory().createCoordinate((x1 + x2) / 2.0, (y1 + y2) / 2.0));
        } else {
            pointa = point2;
            point2 = points.get(points.size() / 2 + 1);
            x2 = point2.getX();
            y2 = point2.getY();
        }
        double xs = pointa.getX();
        double ys = pointa.getY();
        ImmutablePoint pointb = this.getNormalPoint(left, length, x1, y1, x2, y2, xs, ys);
        return ImmutableGeoObjectFactory.createImmutableLineStringFromPoints(pointa, pointb);
    }

    private ImmutablePoint getNormalPoint(boolean left, double length, double x1, double y1, double x2, double y2, double xs, double ys) {
        double xd = 0.0;
        double yd = 0.0;
        if (x1 != x2 || y1 != y2) {
            if (x1 == x2) {
                xd = y1 > y2 == left ? length : -length;
            } else if (y1 == y2) {
                yd = x1 < x2 == left ? length : -length;
            } else {
                double angle = Math.atan2(y2 - y1, x2 - x1);
                angle = left ? (angle += 1.5707963267948966) : (angle -= 1.5707963267948966);
                xd = Math.cos(angle) * length;
                yd = Math.sin(angle) * length;
            }
        }
        ImmutablePoint pointb = ImmutableGeoObjectFactory.createImmutablePoint(this.getCoordinateFactory().createCoordinate(xs + xd, ys + yd));
        return pointb;
    }
}

