/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.geo;

import com.vividsolutions.jts.geom.GeometryCollection;
import de.datomino.util.geo.AbstractImmutableValidGeoObject;
import de.datomino.util.geo.ImmutableGeoObject;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.ImmutablePolygonKind;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.ktde.math.projection.CoordinateFactory;

public class ImmutableGeometryCollection
extends AbstractImmutableValidGeoObject<ImmutableGeometryCollection, GeometryCollection> {
    private transient List<ImmutableGeoObject> parts;

    protected ImmutableGeometryCollection(GeometryCollection geometry, CoordinateFactory coordinateFactory) {
        super(geometry, coordinateFactory);
    }

    private void init() {
        this.parts = new LinkedList<ImmutableGeoObject>();
        GeometryCollection geometry = (GeometryCollection)this.getGeometry();
        for (int i = 0; i < geometry.getNumGeometries(); ++i) {
            this.parts.add(ImmutableGeoObjectFactory.createImmutableGeoObject(geometry.getGeometryN(i), this.getCoordinateFactory()));
        }
    }

    public List<ImmutableGeoObject> getParts() {
        if (this.parts == null) {
            this.init();
        }
        return this.parts;
    }

    @Override
    public List<ImmutablePoint> getCoordinates() {
        LinkedList<ImmutablePoint> points = new LinkedList<ImmutablePoint>();
        List<ImmutableGeoObject> parts = this.getParts();
        for (ImmutableGeoObject immutableGeoObject : parts) {
            points.addAll(immutableGeoObject.getCoordinates());
        }
        return points;
    }

    @Override
    public ImmutablePoint getAnyPoint() {
        List<ImmutableGeoObject> parts = this.getParts();
        for (ImmutableGeoObject immutableGeoObject : parts) {
            List<ImmutablePoint> points = immutableGeoObject.getCoordinates();
            if (points.isEmpty()) continue;
            return points.get(0);
        }
        return null;
    }

    public <T extends ImmutableGeoObject> List<T> filter(Class<T> clazz) {
        List<ImmutableGeoObject> parts = this.getParts();
        LinkedList<ImmutableGeoObject> result = new LinkedList<ImmutableGeoObject>();
        for (ImmutableGeoObject part : parts) {
            if (!clazz.isInstance(part)) continue;
            result.add(part);
        }
        return result;
    }

    public ImmutablePolygonKind unionPolygonsToOneMultiPolygon() {
        List<ImmutablePolygonKind> polygons = this.filter(ImmutablePolygonKind.class);
        if (polygons.isEmpty()) {
            return null;
        }
        Iterator<ImmutablePolygonKind> iter = polygons.iterator();
        ImmutablePolygonKind result = iter.next();
        while (iter.hasNext()) {
            ImmutablePolygonKind next = iter.next();
            ImmutableGeoObject union = result.union(next);
            if (union instanceof ImmutableGeometryCollection) {
                result = ((ImmutableGeometryCollection)union).unionPolygonsToOneMultiPolygon();
                continue;
            }
            result = (ImmutablePolygonKind)union;
        }
        return result;
    }
}

