/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.geo;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKBReader;
import com.vividsolutions.jts.io.WKBWriter;
import com.vividsolutions.jts.io.WKTReader;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.collection.Transformer;
import de.datomino.util.geo.AbstractImmutableGeoObject;
import de.datomino.util.geo.AbstractImmutableValidGeoObject;
import de.datomino.util.geo.GeomAccess;
import de.datomino.util.geo.ImmutableGeoObject;
import de.datomino.util.geo.ImmutableGeometryCollection;
import de.datomino.util.geo.ImmutableInvalidGeoObject;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutableMultiLineString;
import de.datomino.util.geo.ImmutableMultiPolygon;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.ImmutablePolygon;
import de.datomino.util.geo.ImmutablePolygonKind;
import de.datomino.util.geo.exception.IllegalPointCountException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;

public class ImmutableGeoObjectFactory {
    public static AbstractImmutableGeoObject createImmutableGeoObject(Geometry geometry, CoordinateFactory coordinateFactory) {
        if (geometry instanceof Point) {
            return new ImmutablePoint((Point)geometry, coordinateFactory);
        }
        if (geometry instanceof LineString) {
            return new ImmutableLineString((LineString)geometry, coordinateFactory);
        }
        if (geometry instanceof Polygon) {
            return new ImmutablePolygon((Polygon)geometry, coordinateFactory);
        }
        if (geometry instanceof MultiPolygon) {
            return new ImmutableMultiPolygon((MultiPolygon)geometry, coordinateFactory);
        }
        if (geometry instanceof GeometryCollection) {
            GeometryCollection geometryCollection = (GeometryCollection)geometry;
            if (geometryCollection.isEmpty()) {
                return null;
            }
            return new ImmutableGeometryCollection(geometryCollection, coordinateFactory);
        }
        throw new IllegalArgumentException(geometry.getClass() + " currently not supported");
    }

    public static ImmutablePoint createImmutablePoint(Coordinate coordinate) {
        GeometryFactory geometryFactory = new GeometryFactory();
        com.vividsolutions.jts.geom.Coordinate coord = new com.vividsolutions.jts.geom.Coordinate(coordinate.getX(), coordinate.getY());
        Point point = geometryFactory.createPoint(coord);
        return new ImmutablePoint(point, coordinate);
    }

    public static ImmutableLineString createImmutableLineStringFromPoints(ImmutablePoint ... points) throws IllegalArgumentException {
        LinkedList<Coordinate> coordinates = new LinkedList<Coordinate>();
        for (ImmutablePoint point : points) {
            coordinates.add(point.getCoordinate());
        }
        return ImmutableGeoObjectFactory.createImmutableLineString(coordinates);
    }

    public static ImmutableLineString createImmutableLineStringFromPoints(List<ImmutablePoint> points) throws IllegalArgumentException {
        LinkedList<Coordinate> coordinates = new LinkedList<Coordinate>();
        for (ImmutablePoint point : points) {
            coordinates.add(point.getCoordinate());
        }
        return ImmutableGeoObjectFactory.createImmutableLineString(coordinates);
    }

    public static ImmutableLineString createImmutableLineString(Coordinate[] coords) throws IllegalArgumentException {
        return ImmutableGeoObjectFactory.createImmutableLineString(Arrays.asList(coords));
    }

    public static ImmutableLineString createImmutableLineString(List<Coordinate> coords) throws IllegalArgumentException {
        GeometryFactory geometryFactory = new GeometryFactory();
        LinkedList<Coordinate> unredundantCoords = new LinkedList<Coordinate>();
        Coordinate lastCoord = null;
        for (Coordinate coordinate : coords) {
            if (coordinate.equals(lastCoord)) continue;
            unredundantCoords.add(coordinate);
            lastCoord = coordinate;
        }
        com.vividsolutions.jts.geom.Coordinate[] coordinates = ImmutableGeoObjectFactory.convertCoordinates(unredundantCoords);
        return new ImmutableLineString(geometryFactory.createLineString(coordinates), coords.get(0).getFactory());
    }

    public static ImmutableLineString createImmutableLineString(Coordinate coord1, Coordinate coord2, Coordinate ... coord3) throws IllegalArgumentException {
        LinkedList<Coordinate> coords = new LinkedList<Coordinate>();
        coords.add(coord1);
        coords.add(coord2);
        for (Coordinate c : coord3) {
            coords.add(c);
        }
        return ImmutableGeoObjectFactory.createImmutableLineString(coords);
    }

    public static ImmutableLineString createImmutableLineStringByPoints(ImmutablePoint point1, ImmutablePoint point2, ImmutablePoint ... points) {
        ArrayList<ImmutablePoint> pointList = new ArrayList<ImmutablePoint>(2 + points.length);
        pointList.add(point1);
        pointList.add(point2);
        pointList.addAll(Arrays.asList(points));
        return ImmutableGeoObjectFactory.createImmutableLineStringByPoints(pointList);
    }

    public static ImmutableLineString createImmutableLineStringByPoints(List<ImmutablePoint> points) {
        ArrayList<Coordinate> coords = new ArrayList<Coordinate>(points.size());
        CollectionUtil.transform(points, coords, new Transformer<ImmutablePoint, Coordinate>(){

            @Override
            public Coordinate transform(ImmutablePoint t) {
                return t.getCoordinate();
            }
        });
        return ImmutableGeoObjectFactory.createImmutableLineString(coords);
    }

    public static ImmutableInvalidGeoObject createInvalidGeoObject(String wkb, CoordinateFactory factory) {
        return new ImmutableInvalidGeoObject(factory, wkb);
    }

    public static ImmutablePolygon createImmutablePolygonByLineStrings(List<ImmutableLineString> lineStrings) throws IllegalPointCountException {
        return ImmutableGeoObjectFactory.createImmutablePolygonByLineStrings(lineStrings, false);
    }

    public static ImmutablePolygon createImmutablePolygonByLineStrings(List<ImmutableLineString> lineStrings, boolean concatenate) throws IllegalPointCountException {
        LinkedList<ImmutableLineString> holeLineStrings = new LinkedList<ImmutableLineString>();
        Iterator<ImmutableLineString> iter = lineStrings.iterator();
        ImmutableLineString lineString = iter.next();
        while (iter.hasNext()) {
            holeLineStrings.add(iter.next());
        }
        return ImmutableGeoObjectFactory.createImmutablePolygonByLineStrings(lineString, concatenate, holeLineStrings);
    }

    public static ImmutablePolygon createImmutablePolygonByLineStrings(ImmutableLineString lineString, ImmutableLineString ... holeLineStrings) throws IllegalPointCountException {
        return ImmutableGeoObjectFactory.createImmutablePolygonByLineStrings(lineString, false, Arrays.asList(holeLineStrings));
    }

    public static ImmutablePolygon createImmutablePolygonByLineStrings(ImmutableLineString lineString, List<ImmutableLineString> holeLineStrings) throws IllegalPointCountException {
        return ImmutableGeoObjectFactory.createImmutablePolygonByLineStrings(lineString, false, holeLineStrings);
    }

    public static ImmutablePolygon createImmutablePolygonByLineStrings(ImmutableLineString lineString, boolean concatenate, List<ImmutableLineString> holeLineStrings) throws IllegalPointCountException {
        return ImmutableGeoObjectFactory.createImmutablePolygonByLineStrings(lineString, concatenate, holeLineStrings, false);
    }

    public static ImmutablePolygon createImmutablePolygonByLineStrings(ImmutableLineString lineString, boolean concatenate, List<ImmutableLineString> holeLineStrings, boolean ignoreBrokenHoles) throws IllegalPointCountException {
        List<List<ImmutablePoint>> holePoints;
        LinkedList<ImmutablePoint> points = new LinkedList<ImmutablePoint>();
        points.addAll(lineString.getCoordinates());
        if (concatenate) {
            holePoints = Collections.emptyList();
            for (ImmutableLineString holeLineString : holeLineStrings) {
                points.addAll(holeLineString.getCoordinates());
            }
        } else {
            holePoints = new ArrayList(holeLineStrings.size());
            for (ImmutableLineString holeLineString : holeLineStrings) {
                holePoints.add(new ArrayList<ImmutablePoint>(holeLineString.getCoordinates()));
            }
        }
        return ImmutableGeoObjectFactory.createImmutablePolygon(points, holePoints, ignoreBrokenHoles);
    }

    public static ImmutablePolygon createImmutablePolygon(List<ImmutablePoint> points) throws IllegalPointCountException {
        List<List<ImmutablePoint>> emptyList = Collections.emptyList();
        return ImmutableGeoObjectFactory.createImmutablePolygon(points, emptyList);
    }

    public static ImmutablePolygon createImmutablePolygon(List<ImmutablePoint> points, List<ImmutablePoint> ... holePoints) throws IllegalPointCountException {
        return ImmutableGeoObjectFactory.createImmutablePolygon(points, Arrays.asList(holePoints));
    }

    public static ImmutablePolygon createImmutablePolygonByCoordinates(List<Coordinate> coords, List<List<Coordinate>> holeCoords) throws IllegalPointCountException {
        ArrayList<ImmutablePoint> points = new ArrayList<ImmutablePoint>(coords.size());
        ArrayList<List<ImmutablePoint>> holePoints = new ArrayList<List<ImmutablePoint>>(holeCoords.size());
        for (Coordinate coordinate : coords) {
            points.add(ImmutableGeoObjectFactory.createImmutablePoint(coordinate));
        }
        for (List list : holeCoords) {
            ArrayList<ImmutablePoint> sHolePoints = new ArrayList<ImmutablePoint>(list.size());
            for (Coordinate coord : list) {
                sHolePoints.add(ImmutableGeoObjectFactory.createImmutablePoint(coord));
            }
            holePoints.add(sHolePoints);
        }
        return ImmutableGeoObjectFactory.createImmutablePolygon(points, holePoints);
    }

    public static ImmutablePolygon createImmutablePolygon(List<ImmutablePoint> points, List<List<ImmutablePoint>> holePoints) throws IllegalPointCountException {
        return ImmutableGeoObjectFactory.createImmutablePolygon(points, holePoints, false);
    }

    public static ImmutablePolygon createImmutablePolygon(List<ImmutablePoint> points, List<List<ImmutablePoint>> holePoints, boolean ignoreBrokenHoles) throws IllegalPointCountException {
        GeometryFactory geometryFactory = new GeometryFactory();
        LinearRing shell = ImmutableGeoObjectFactory.createLinearRing(points, geometryFactory);
        ArrayList<LinearRing> holes = new ArrayList<LinearRing>(holePoints.size());
        boolean i = false;
        for (List<ImmutablePoint> hole : holePoints) {
            try {
                LinearRing linearRingHole = ImmutableGeoObjectFactory.createLinearRing(hole, geometryFactory);
                holes.add(linearRingHole);
            }
            catch (IllegalPointCountException ex) {
                if (ignoreBrokenHoles) continue;
                throw ex;
            }
        }
        LinearRing[] holeArray = new LinearRing[holes.size()];
        holeArray = holes.toArray(holeArray);
        return new ImmutablePolygon(geometryFactory.createPolygon(shell, holeArray), points.get(0).getCoordinateFactory());
    }

    private static LinearRing createLinearRing(List<ImmutablePoint> points, GeometryFactory geometryFactory) throws IllegalPointCountException {
        com.vividsolutions.jts.geom.Coordinate[] coords;
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>(points.size());
        ImmutablePoint before = null;
        for (ImmutablePoint point : points) {
            if (point.equals(before)) continue;
            coordinates.add(point.getCoordinate());
            before = point;
        }
        if (coordinates.isEmpty()) {
            coords = new com.vividsolutions.jts.geom.Coordinate[]{};
        } else if (!((Coordinate)coordinates.get(0)).equals(coordinates.get(coordinates.size() - 1))) {
            coords = ImmutableGeoObjectFactory.convertCoordinates(coordinates, 0, 1);
            coords[coords.length - 1] = coords[0];
        } else {
            coords = ImmutableGeoObjectFactory.convertCoordinates(coordinates);
        }
        if (coords.length < 4) {
            throw new IllegalPointCountException("Polygon must contain of at least 3 different points", coords.length - 1);
        }
        LinearRing shell = geometryFactory.createLinearRing(coords);
        return shell;
    }

    private static com.vividsolutions.jts.geom.Coordinate[] convertCoordinates(Collection<Coordinate> coords) {
        return ImmutableGeoObjectFactory.convertCoordinates(coords, 0, 0);
    }

    private static com.vividsolutions.jts.geom.Coordinate[] convertCoordinates(Collection<Coordinate> coords, int emptyPlacesStart, int emptyPlacesEnd) {
        com.vividsolutions.jts.geom.Coordinate[] coordinates = new com.vividsolutions.jts.geom.Coordinate[coords.size() + emptyPlacesStart + emptyPlacesEnd];
        int i = emptyPlacesStart;
        for (Coordinate c : coords) {
            com.vividsolutions.jts.geom.Coordinate coord = new com.vividsolutions.jts.geom.Coordinate(c.getX(), c.getY());
            coordinates[i++] = coord;
        }
        return coordinates;
    }

    public static ImmutableGeoObject createImmutableGeoObject(String wkb, CoordinateFactory coordinateFactory) throws ParseException {
        return ImmutableGeoObjectFactory.createImmutableGeoObject(new WKBReader().read(WKBReader.hexToBytes(wkb)), coordinateFactory);
    }

    public static ImmutableGeoObject createImmutableGeoObjectFromWkt(String wkt, CoordinateFactory coordinateFactory) throws ParseException {
        return ImmutableGeoObjectFactory.createImmutableGeoObject(new WKTReader().read(wkt), coordinateFactory);
    }

    public static <T extends Geometry> ImmutableInvalidGeoObject createInvalidGeoObject(AbstractImmutableValidGeoObject<?, T> geom) {
        T geometry = geom.getGeometry();
        String wkb = WKBWriter.toHex(new WKBWriter().write((Geometry)geometry));
        return ImmutableGeoObjectFactory.createInvalidGeoObject(wkb, geom.getCoordinateFactory());
    }

    public static <T extends Geometry> ImmutableInvalidGeoObject createInvalidGeoObject(ImmutableGeoObject geom) {
        if (geom instanceof ImmutableInvalidGeoObject) {
            return (ImmutableInvalidGeoObject)geom;
        }
        return ImmutableGeoObjectFactory.createInvalidGeoObject((AbstractImmutableValidGeoObject)geom);
    }

    public static ImmutableMultiPolygon createImmutableMultiPolygonByParts(CoordinateFactory coordinateFactory, List<ImmutablePolygon> parts) {
        GeometryFactory geometryFactory = new GeometryFactory();
        Polygon[] polygons = new Polygon[parts.size()];
        int i = 0;
        for (ImmutablePolygon polygon : parts) {
            polygons[i++] = (Polygon)polygon.getGeometry();
        }
        return new ImmutableMultiPolygon(geometryFactory.createMultiPolygon(polygons), coordinateFactory);
    }

    public static ImmutableMultiLineString createImmutableMultiLinestring(Collection<? extends GeomAccess<ImmutableLineString>> parts) {
        CoordinateFactory coordinateFactory = parts.iterator().next().getGeom().getCoordinateFactory();
        LinkedList<ImmutableLineString> collection = new LinkedList<ImmutableLineString>();
        for (GeomAccess<ImmutableLineString> geomAccess : parts) {
            collection.add(geomAccess.getGeom());
        }
        return ImmutableGeoObjectFactory.createImmutableMultiLinestring(coordinateFactory, collection);
    }

    public static ImmutableMultiLineString createImmutableMultiLinestring(CoordinateFactory coordinateFactory, Collection<ImmutableLineString> parts) {
        GeometryFactory geometryFactory = new GeometryFactory();
        LineString[] lineStrings = new LineString[parts.size()];
        int i = 0;
        for (ImmutableLineString linestring : parts) {
            lineStrings[i++] = (LineString)linestring.getGeometry();
        }
        return new ImmutableMultiLineString(geometryFactory.createMultiLineString(lineStrings), coordinateFactory);
    }

    public static ImmutablePolygonKind createImmutableMultiPolygon(CoordinateFactory coordinateFactory, MultiPolygon multiPolygon) {
        return new ImmutableMultiPolygon(multiPolygon, coordinateFactory);
    }

    public static ImmutableGeometryCollection createImmutableGeometryCollection(List<ImmutableGeoObject> geoms, CoordinateFactory coordinateFactory) {
        GeometryFactory geometryFactory = new GeometryFactory();
        Geometry[] geometries = new Geometry[geoms.size()];
        int i = 0;
        for (ImmutableGeoObject immutableGeoObject : geoms) {
            geometries[i] = immutableGeoObject.getGeometryClone(coordinateFactory);
            ++i;
        }
        return new ImmutableGeometryCollection(geometryFactory.createGeometryCollection(geometries), coordinateFactory);
    }

    public static ImmutablePolygon createImmutablePolygonRectangle(ImmutablePoint bottomLeft, ImmutablePoint topRight) throws IllegalPointCountException {
        ImmutablePoint topLeft = ImmutableGeoObjectFactory.createImmutablePoint(bottomLeft.getCoordinateFactory().createCoordinate(bottomLeft.getX(), topRight.getY()));
        ImmutablePoint bottomRight = ImmutableGeoObjectFactory.createImmutablePoint(bottomLeft.getCoordinateFactory().createCoordinate(topRight.getX(), bottomLeft.getY()));
        return ImmutableGeoObjectFactory.createImmutablePolygon(Arrays.asList(bottomLeft, topLeft, topRight, bottomRight));
    }
}

