/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.geo;

import com.vividsolutions.jts.geom.Geometry;
import de.datomino.util.geo.AbstractImmutableValidGeoObject;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutablePoint;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.ktde.math.projection.CoordinateFactory;

public abstract class AbstractImmutableMultiGeom<V extends AbstractImmutableMultiGeom<V, S, T, U>, S extends AbstractImmutableValidGeoObject<S, T>, T extends Geometry, U extends Geometry>
extends AbstractImmutableValidGeoObject<V, U> {
    private transient List<S> parts;

    protected AbstractImmutableMultiGeom(U geometry, CoordinateFactory coordinateFactory) {
        super(geometry, coordinateFactory);
        this.init();
    }

    protected void init() {
        int length = ((Geometry)this.getGeometry()).getNumGeometries();
        this.parts = new ArrayList<S>(length);
        for (int i = 0; i < length; ++i) {
            this.parts.add((AbstractImmutableValidGeoObject)ImmutableGeoObjectFactory.createImmutableGeoObject(((Geometry)this.getGeometry()).getGeometryN(i), this.getCoordinateFactory()));
        }
    }

    public List<S> getParts() {
        if (this.parts == null) {
            this.init();
        }
        return this.parts;
    }

    protected abstract AbstractImmutableMultiGeom<V, S, T, U> getInstance(CoordinateFactory var1, List<S> var2);

    @Override
    public ImmutablePoint getAnyPoint() {
        return ((AbstractImmutableValidGeoObject)this.getParts().get(0)).getAnyPoint();
    }

    @Override
    public List<ImmutablePoint> getCoordinates() {
        LinkedList<ImmutablePoint> points = new LinkedList<ImmutablePoint>();
        for (AbstractImmutableValidGeoObject part : this.getParts()) {
            points.addAll(part.getCoordinates());
        }
        return points;
    }
}

