/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.configuration;

import de.datomino.util.license.LicenseUtil;
import de.datomino.util.server.FileKeeperBean;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import javax.servlet.GenericServlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.ktde.util.StringUtil;
import org.ktde.util.application.ClientApplicationProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatominoInitializerServlet
extends GenericServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatominoInitializerServlet.class);
    private static final long serialVersionUID = 3408598322550628807L;
    private static String md5Hash;
    private static String servletName;

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        File servletFile = new File(this.getServletContext().getRealPath("/"));
        String servletDir = servletFile.getName();
        ClientApplicationProperties.setSpecificFileName(servletDir);
        FileKeeperBean.setServletName(servletDir);
        File warFile = new File(servletFile.getParentFile(), servletDir + ".war");
        try {
            byte[] md5 = DigestUtils.md5(FileUtils.readFileToByteArray(warFile));
            BigInteger b = new BigInteger(1, md5);
            md5Hash = b.toString(16);
            servletName = servletDir;
        }
        catch (IOException e) {
            LOGGER.warn(e.getMessage(), e);
            throw new ServletException(e);
        }
        this.checkLicense();
    }

    private void checkLicense() {
        String checkTypeString = this.getServletContext().getInitParameter("checkType");
        if (!StringUtil.isBlank(checkTypeString)) {
            LicenseUtil.CheckType checkType = LicenseUtil.CheckType.valueOf(checkTypeString);
            FileKeeperBean fileKeeperBean = new FileKeeperBean();
            fileKeeperBean.setApplicationName(servletName);
            File licenseFile = fileKeeperBean.getFileForName("lic3");
            LicenseUtil.getLicenseObject(checkType, licenseFile, true);
        }
    }

    @Override
    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
    }

    public static String getMd5Hash() {
        return md5Hash;
    }

    public static String getKeyName() {
        return servletName;
    }
}

