/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.configuration;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextStartedEvent;
import org.springframework.jdbc.datasource.AbstractDriverBasedDataSource;

public class DataSourceLogger
implements ApplicationListener<ContextStartedEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataSourceLogger.class);

    @Override
    public void onApplicationEvent(ContextStartedEvent event) {
        ApplicationContext applicationContext = event.getApplicationContext();
        String[] beanNames = applicationContext.getBeanNamesForType(AbstractDriverBasedDataSource.class);
        StringBuilder sb = new StringBuilder("Following datasource connections are used:");
        for (String beanName : beanNames) {
            AbstractDriverBasedDataSource dataSource = (AbstractDriverBasedDataSource)applicationContext.getBean(beanName);
            sb.append("\n").append(beanName).append(" - ").append(dataSource.getUrl()).append(" - ").append(dataSource.getUsername());
        }
        LOGGER.info(sb.toString());
    }
}

