/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.comparator;

import java.util.Comparator;
import org.ktde.util.StringUtil;

public class NextToRefStringComparator
implements Comparator<String> {
    private String refValue;

    public NextToRefStringComparator(String refValue) {
        this.refValue = StringUtil.normalize(refValue.trim().toLowerCase());
    }

    @Override
    public int compare(String value1, String value2) {
        String normalized1 = StringUtil.normalize(StringUtil.nullToEmpty(value1).trim().toLowerCase());
        String normalized2 = StringUtil.normalize(StringUtil.nullToEmpty(value2).trim().toLowerCase());
        int refValueLength = this.refValue.length();
        for (int i = 0; i < refValueLength; ++i) {
            if (i == normalized1.length()) {
                if (i == normalized2.length()) {
                    return 0;
                }
                return 1;
            }
            if (i == normalized2.length()) {
                if (i == normalized1.length()) {
                    return 0;
                }
                return -1;
            }
            char c = this.refValue.charAt(i);
            try {
                int dist1 = StringUtil.getLexicalDistance(normalized1.charAt(i), c);
                int dist2 = StringUtil.getLexicalDistance(normalized2.charAt(i), c);
                if (dist1 > dist2) {
                    return 1;
                }
                if (dist1 >= dist2) continue;
                return -1;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return normalized1.substring(refValueLength).compareTo(normalized2.substring(refValueLength));
    }
}

