/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.comparator;

import java.util.Comparator;
import org.apache.commons.collections.ComparatorUtils;

public final class ComparatorUtil {
    private ComparatorUtil() {
    }

    public static Comparator<?> chainedComparator(Comparator<?> ... comparator) {
        return ComparatorUtils.chainedComparator(comparator);
    }

    public static <T> int compareMultipleValueChain(CompareUnit<T> ... compareUnits) {
        for (CompareUnit<T> compareUnit : compareUnits) {
            int d = ((CompareUnit)compareUnit).comparator.compare(compareUnit.getT1(), compareUnit.getT2());
            if (d == 0) continue;
            return d;
        }
        return 0;
    }

    public static class CompareUnit<T> {
        private Comparator<T> comparator;
        private T t1;
        private T t2;

        public CompareUnit(Comparator<T> comparator, T t1, T t2) {
            this.comparator = comparator;
            this.t1 = t1;
            this.t2 = t2;
        }

        public Comparator<T> getComparator() {
            return this.comparator;
        }

        public T getT1() {
            return this.t1;
        }

        public T getT2() {
            return this.t2;
        }
    }
}

