/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.communication;

import de.datomino.util.communication.AbstractHttpResponse;
import de.datomino.util.communication.HttpResponse;
import de.datomino.util.communication.StreamHttpResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;

public final class HttpUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpUtil.class);
    private static final char[] HEXDIGITS = "0123456789abcdef".toCharArray();
    private static Scheme httpsScheme;

    private HttpUtil() {
    }

    public static HttpResponse get(String targetUrl) throws HttpException, IOException {
        Map<String, String> headers = null;
        return HttpUtil.get(targetUrl, headers);
    }

    public static HttpResponse get(String targetUrl, Map<String, String> headers) throws HttpException, IOException {
        return (HttpResponse)HttpUtil.send(targetUrl, null, headers, HttpMethod.GET, null, null);
    }

    public static HttpResponse get(String targetUrl, Map<String, String> headers, String encoding) throws HttpException, IOException {
        return (HttpResponse)HttpUtil.send(targetUrl, null, headers, HttpMethod.GET, encoding, null);
    }

    public static HttpResponse post(String targetUrl, String input) throws HttpException, IOException {
        return HttpUtil.post(targetUrl, input, (String)null);
    }

    public static HttpResponse post(String targetUrl, String input, String encoding) throws HttpException, IOException {
        Map<String, String> headers = null;
        return HttpUtil.post(targetUrl, input, encoding, headers);
    }

    public static HttpResponse post(String targetUrl, String input, Map<String, String> headers) throws HttpException, IOException {
        return HttpUtil.post(targetUrl, input, null, headers);
    }

    public static HttpResponse post(String targetUrl, String input, String encoding, Map<String, String> headers) throws HttpException, IOException {
        return (HttpResponse)HttpUtil.send(targetUrl, input, headers, HttpMethod.POST, encoding, null);
    }

    public static HttpResponse post(String targetUrl, byte[] input, String encoding, Map<String, String> headers) throws HttpException, IOException {
        return (HttpResponse)HttpUtil.send(targetUrl, input, headers, HttpMethod.POST, encoding, null);
    }

    public static HttpResponse post(String targetUrl, byte[] input, Map<String, String> headers) throws HttpException, IOException {
        return (HttpResponse)HttpUtil.send(targetUrl, input, headers, HttpMethod.POST, null, null);
    }

    public static HttpResponse post(String targetUrl, byte[] input) throws HttpException, IOException {
        return HttpUtil.post(targetUrl, input, null);
    }

    public static HttpResponse post(String targetUrl, Map<String, String> values) throws HttpException, IOException {
        return HttpUtil.post(targetUrl, values, null);
    }

    public static HttpResponse postMultiString(String targetUrl, List<Tupel<String, String>> multiParts, Map<String, String> headers) throws HttpException, IOException {
        return (HttpResponse)HttpUtil.send(targetUrl, new StringMultipartList(multiParts), headers, HttpMethod.POST, null, null);
    }

    public static HttpResponse postMultiByte(String targetUrl, List<Tupel<String, byte[]>> multiParts, Map<String, String> headers) throws HttpException, IOException {
        return (HttpResponse)HttpUtil.send(targetUrl, new ByteMultipartList(multiParts), headers, HttpMethod.POST, null, null);
    }

    public static HttpResponse post(String targetUrl, Map<String, String> values, Map<String, String> headers) throws HttpException, IOException {
        return (HttpResponse)HttpUtil.send(targetUrl, values, headers, HttpMethod.POST, null, null);
    }

    public static StreamHttpResponse get(String targetUrl, OutputStream out) throws HttpException, IOException {
        return HttpUtil.get(targetUrl, null, out);
    }

    public static StreamHttpResponse get(String targetUrl, Map<String, String> headers, OutputStream out) throws HttpException, IOException {
        return (StreamHttpResponse)HttpUtil.send(targetUrl, null, headers, HttpMethod.GET, null, out);
    }

    public static StreamHttpResponse get(String targetUrl, Map<String, String> headers, String encoding, OutputStream out) throws HttpException, IOException {
        return (StreamHttpResponse)HttpUtil.send(targetUrl, null, headers, HttpMethod.GET, encoding, out);
    }

    public static StreamHttpResponse post(String targetUrl, String input, OutputStream out) throws HttpException, IOException {
        return HttpUtil.post(targetUrl, input, (String)null, out);
    }

    public static StreamHttpResponse post(String targetUrl, String input, String encoding, OutputStream out) throws HttpException, IOException {
        return HttpUtil.post(targetUrl, input, encoding, null, out);
    }

    public static StreamHttpResponse post(String targetUrl, String input, Map<String, String> headers, OutputStream out) throws HttpException, IOException {
        return HttpUtil.post(targetUrl, input, null, headers, out);
    }

    public static StreamHttpResponse post(String targetUrl, String input, String encoding, Map<String, String> headers, OutputStream out) throws HttpException, IOException {
        return (StreamHttpResponse)HttpUtil.send(targetUrl, input, headers, HttpMethod.POST, encoding, out);
    }

    public static StreamHttpResponse post(String targetUrl, byte[] input, String encoding, Map<String, String> headers, OutputStream out) throws HttpException, IOException {
        return (StreamHttpResponse)HttpUtil.send(targetUrl, input, headers, HttpMethod.POST, encoding, out);
    }

    private static AbstractHttpResponse send(String targetUrl, Object input, Map<String, String> headers, HttpMethod httpMethod, String encoding, OutputStream out) throws HttpException, IOException {
        URL url = new URL(targetUrl);
        int port = url.getPort();
        boolean ssl = false;
        if (port < 0) {
            String protocol = url.getProtocol();
            if (StringUtil.isBlank(protocol) || protocol.equals("http")) {
                port = 80;
            } else if (protocol.equals("https")) {
                port = 443;
                ssl = true;
            } else {
                throw new HttpException("Unknown protocol: " + protocol);
            }
        }
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpUtil.setProxyIfNecessary(httpclient);
        HttpHost targetHost = new HttpHost(url.getHost(), url.getPort(), url.getProtocol());
        HttpRequestBase request = null;
        String query = url.getQuery();
        String uri = url.getPath() + (query == null ? "" : "?" + query);
        switch (httpMethod) {
            case GET: {
                request = new HttpGet(uri);
                break;
            }
            case POST: {
                request = new HttpPost(uri);
                break;
            }
        }
        request.addHeader("Host", url.getHost());
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                request.addHeader(entry.getKey(), entry.getValue());
            }
        }
        if (input != null) {
            Object multipartList;
            MultipartEntity multiPartEntity;
            HttpEntity entity;
            if (input instanceof String) {
                entity = new StringEntity((String)input, encoding);
            } else if (input instanceof byte[]) {
                entity = new ByteArrayEntity((byte[])input);
            } else if (input instanceof Map) {
                Map values = (Map)input;
                ArrayList<BasicNameValuePair> postParameters = new ArrayList<BasicNameValuePair>(values.size());
                for (Map.Entry entry : values.entrySet()) {
                    postParameters.add(new BasicNameValuePair((String)entry.getKey(), (String)entry.getValue()));
                }
                entity = new UrlEncodedFormEntity(postParameters);
            } else if (input instanceof ByteMultipartList) {
                multiPartEntity = new MultipartEntity();
                multipartList = (ByteMultipartList)input;
                for (Tupel<String, byte[]> part : ((ByteMultipartList)multipartList).multiparts) {
                    multiPartEntity.addPart(part.getElement1(), new InputStreamBody(new ByteArrayInputStream(part.getElement2()), "form-data", ""));
                }
                entity = multiPartEntity;
            } else if (input instanceof StringMultipartList) {
                multiPartEntity = new MultipartEntity();
                multipartList = (StringMultipartList)input;
                for (Tupel<String, String> part : ((StringMultipartList)multipartList).multiparts) {
                    multiPartEntity.addPart(part.getElement1(), new StringBody(part.getElement2(), "form-data", Charset.forName("UTF-8")));
                }
                entity = multiPartEntity;
            } else {
                throw new RuntimeException();
            }
            ((HttpEntityEnclosingRequest)((Object)request)).setEntity(entity);
        }
        if (ssl && httpsScheme != null) {
            httpclient.getConnectionManager().getSchemeRegistry().register(httpsScheme);
        }
        HttpUtil.logHttpRequest(request);
        org.apache.http.HttpResponse rresponse = httpclient.execute(targetHost, request);
        AbstractHttpResponse response = out == null ? new HttpResponse(rresponse) : new StreamHttpResponse(rresponse, out);
        HttpEntity entity = rresponse.getEntity();
        if (entity != null) {
            entity.consumeContent();
        }
        httpclient.getConnectionManager().shutdown();
        return response;
    }

    private static void logHttpRequest(HttpRequestBase request) throws IOException {
        Header[] headers = request.getAllHeaders();
        StringBuilder sb = new StringBuilder("Headers\n");
        for (Header header : headers) {
            sb.append(header.getName()).append(": ").append(header.getValue()).append("\n");
        }
        sb.append("\nContent:\n");
        if (request instanceof HttpPost) {
            HttpPost httpPost = (HttpPost)request;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            httpPost.getEntity().writeTo(baos);
            sb.append(new String(baos.toByteArray()));
        }
        LOGGER.info(sb.toString());
    }

    public static URL createUrl(String baseurl, List<NameValuePair> pairs) throws MalformedURLException {
        return new URL(baseurl + "?" + URLEncodedUtils.format(pairs, "UTF-8"));
    }

    private static void setProxyIfNecessary(DefaultHttpClient client) {
        String proxyHost = System.getProperty("proxyHost");
        String proxyPort = System.getProperty("proxyPort");
        if (!StringUtil.isBlank(proxyHost)) {
            int port = StringUtil.isBlank(proxyPort) ? -1 : Integer.parseInt(proxyPort);
            HttpHost proxy = new HttpHost(proxyHost, port);
            client.getParams().setParameter("http.route.default-proxy", proxy);
            String proxyUser = System.getProperty("proxyUser");
            String proxyPassword = StringUtil.nullToEmpty(System.getProperty("proxyPassword"));
            if (!StringUtil.isBlank(proxyUser)) {
                client.getCredentialsProvider().setCredentials(new AuthScope(proxyHost, port), new UsernamePasswordCredentials(proxyUser, proxyPassword));
            }
        }
    }

    public static InputStream getHttpsContent(URL url, KeyStore ks) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException {
        SSLContext context = SSLContext.getInstance("TLS");
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(ks);
        X509TrustManager defaultTrustManager = (X509TrustManager)tmf.getTrustManagers()[0];
        context.init(null, new TrustManager[]{defaultTrustManager}, null);
        javax.net.ssl.SSLSocketFactory factory = context.getSocketFactory();
        HttpsURLConnection con = (HttpsURLConnection)url.openConnection();
        con.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
        con.setSSLSocketFactory(factory);
        return con.getInputStream();
    }

    public static HttpsURLConnection getHttpsConnection(URL url) throws UnsupportedEncodingException, IOException, ProtocolException, NoSuchAlgorithmException, KeyManagementException {
        String credentials = "user:password";
        String encoding = HttpUtil.toHexString(credentials.getBytes("UTF-8"));
        HttpsURLConnection con = (HttpsURLConnection)url.openConnection();
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, new TrustManager[]{new EmptyTrustedManager()}, null);
        con.setSSLSocketFactory(sc.getSocketFactory());
        con.setHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String urlHostName, SSLSession session) {
                return true;
            }
        });
        con.setDoInput(true);
        con.setDoOutput(true);
        con.setRequestProperty("Authorization", String.format("Basic %s", encoding));
        con.setRequestMethod("POST");
        con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
        con.setRequestProperty("Accept", "application/x-www-form-urlencoded; charset=utf-8");
        con.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
        return con;
    }

    public static String toHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 3);
        for (int n : bytes) {
            sb.append(HEXDIGITS[(n &= 0xFF) >> 4]);
            sb.append(HEXDIGITS[n & 0xF]);
            sb.append(' ');
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        FileInputStream stream = null;
        try {
            String file = System.getProperty("javax.net.ssl.keyStore");
            if (file != null) {
                LOGGER.info("Initializing https with keystore: " + file);
                stream = new FileInputStream(file);
                KeyStore instance = KeyStore.getInstance(KeyStore.getDefaultType());
                instance.load(stream, "changeit".toCharArray());
                SSLSocketFactory socketFactory = new SSLSocketFactory(instance);
                httpsScheme = new Scheme("https", socketFactory, 443);
            } else {
                LOGGER.warn("No https keystore specified");
            }
        }
        catch (KeyStoreException e) {
            LOGGER.warn(e.getMessage(), e);
        }
        catch (FileNotFoundException e) {
            LOGGER.warn(e.getMessage(), e);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.warn(e.getMessage(), e);
        }
        catch (CertificateException e) {
            LOGGER.warn(e.getMessage(), e);
        }
        catch (IOException e) {
            LOGGER.warn(e.getMessage(), e);
        }
        catch (KeyManagementException e) {
            LOGGER.warn(e.getMessage(), e);
        }
        catch (UnrecoverableKeyException e) {
            LOGGER.warn(e.getMessage(), e);
        }
        finally {
            if (stream != null) {
                IOUtils.closeQuietly(stream);
            }
        }
    }

    private static class ByteMultipartList {
        List<Tupel<String, byte[]>> multiparts;

        public ByteMultipartList(List<Tupel<String, byte[]>> multiparts) {
            this.multiparts = multiparts;
        }
    }

    private static class StringMultipartList {
        List<Tupel<String, String>> multiparts;

        public StringMultipartList(List<Tupel<String, String>> multiparts) {
            this.multiparts = multiparts;
        }
    }

    private static class EmptyTrustedManager
    implements X509TrustManager {
        private EmptyTrustedManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }
    }
}

