/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.communication;

import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;

public abstract class AbstractHttpResponse {
    private int statusCode;
    private Map<String, String> headers;
    private String encoding;

    public AbstractHttpResponse(HttpResponse response) {
        Header encodingHeader;
        this.statusCode = response.getStatusLine().getStatusCode();
        HttpEntity entity = response.getEntity();
        this.headers = new HashMap<String, String>();
        for (Header header : response.getAllHeaders()) {
            this.headers.put(header.getName(), header.getValue());
        }
        if (entity != null && (encodingHeader = entity.getContentEncoding()) != null) {
            this.encoding = encodingHeader.getValue();
        }
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getEncoding() {
        return this.encoding;
    }
}

