/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.common;

import java.nio.ByteBuffer;
import org.apache.commons.lang.StringUtils;

public final class PrimitiveUtil {
    private PrimitiveUtil() {
    }

    public static int nullToZero(Integer value) {
        return value == null ? 0 : value;
    }

    public static boolean nullToFalse(Boolean bool) {
        return bool == null ? false : bool;
    }

    public static boolean parseBoolean(String s) {
        Boolean b = s == null ? null : Boolean.valueOf(Boolean.parseBoolean(s));
        return PrimitiveUtil.nullToFalse(b);
    }

    public static boolean equalsNullSafe(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static double min(double d, double ... ds) {
        double min = d;
        for (double dd : ds) {
            min = Math.min(min, dd);
        }
        return min;
    }

    public static double nullToZero(Double value) {
        return value == null ? 0.0 : value;
    }

    public static String formatDouble(double d, int dPlaces, boolean cutZeros) {
        long l = Math.round(d * Math.pow(10.0, dPlaces));
        String ls = Long.toString(l);
        ls = StringUtils.leftPad(ls, dPlaces + 1, '0');
        int length = ls.length();
        int dIndex = length - dPlaces;
        String w = ls.substring(0, dIndex);
        String dec = ls.substring(dIndex, length);
        if (cutZeros) {
            int i;
            for (i = dec.length() - 1; i >= 0 && dec.charAt(i) == '0'; --i) {
            }
            dec = dec.substring(0, i + 1);
        }
        if (!dec.isEmpty()) {
            dec = "." + dec;
        }
        return w + dec;
    }

    public static int sumNullAsZero(Integer ... values) {
        int sum = 0;
        for (Integer value : values) {
            if (value == null) continue;
            sum += value.intValue();
        }
        return sum;
    }

    public static byte[] integerToByteArrayLittleEndian(int mobilePauseTime) {
        return ByteBuffer.allocate(4).putInt(mobilePauseTime).array();
    }

    public static int byteArrayToInt(byte[] b) {
        return ByteBuffer.wrap(b).getInt();
    }

    public static int countTrues(boolean ... bs) {
        int count = 0;
        for (boolean b : bs) {
            if (!b) continue;
            ++count;
        }
        return count;
    }

    public static <S extends Comparable<S>> boolean isInInterval(S value, S start, S end, boolean inclusive) {
        int d;
        boolean b = true;
        if (start != null) {
            d = start.compareTo(value);
            boolean bl = b = d < 0 || inclusive && d == 0;
        }
        if (b && end != null) {
            d = end.compareTo(value);
            b = d > 0 || inclusive && d == 0;
        }
        return b;
    }
}

