/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.common;

import java.util.Collection;
import java.util.HashSet;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.math.projection.GeoDecimalFactory;
import org.ktde.util.datatypes.Tupel;

public class CacheUtil {
    public static CoordinateFactory FACTORY = GeoDecimalFactory.INSTANCE;
    public static Integer DEFAULTWIDTH = 50;
    public static Integer DEFAULTHEIGHT = 50;

    public static Tupel<Integer, Integer> getCacheBucket(Coordinate coord, int width, int height) {
        Coordinate coordGeoDecimal = FACTORY.createCoordinate(coord);
        return CacheUtil.getCacheBucket(coordGeoDecimal.getX(), coordGeoDecimal.getY(), width, height);
    }

    public static Collection<Tupel<Integer, Integer>> getCacheBuckets(Coordinate topLeft, Coordinate bottomRight, int width, int height) {
        HashSet<Tupel<Integer, Integer>> cacheBuckets = new HashSet<Tupel<Integer, Integer>>();
        Coordinate topLeftConv = FACTORY.createCoordinate(topLeft);
        Coordinate bottomRightConv = FACTORY.createCoordinate(bottomRight);
        int xSize = (int)Math.ceil(bottomRightConv.getX() - topLeftConv.getX()) / width + 1;
        int ySize = (int)Math.ceil(topLeftConv.getY() - bottomRightConv.getY()) / width + 1;
        for (int x = 0; x < xSize; ++x) {
            for (int y = 0; y < ySize; ++y) {
                cacheBuckets.add(CacheUtil.getCacheBucket(topLeftConv.getX() + (double)(x * width), bottomRightConv.getY() + (double)(y * width), width, height));
            }
        }
        return cacheBuckets;
    }

    private static Tupel<Integer, Integer> getCacheBucket(double x, double y, int width, int height) {
        Double d1 = 0.0;
        if (width > 0) {
            d1 = Math.floor(x / (double)width) * (double)width;
        } else if (width < 0) {
            d1 = Math.floor(x / (double)(-width)) * (double)(-width) + (double)width;
        }
        Double d2 = 0.0;
        if (height > 0) {
            d2 = Math.floor(y / (double)height) * (double)height;
        } else if (height < 0) {
            d2 = Math.floor(y / (double)(-height)) * (double)(-height) + (double)height;
        }
        return new Tupel<Integer, Integer>(d1.intValue(), d2.intValue());
    }
}

