/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.command.shp;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.io.WKBWriter;
import de.datomino.util.geo.ImmutableGeoObject;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.util.LinkedList;
import java.util.List;
import org.geotools.data.shapefile.ShpFiles;
import org.geotools.data.shapefile.shp.ShapefileException;
import org.geotools.data.shapefile.shp.ShapefileReader;
import org.ktde.math.projection.CoordinateFactory;

public class ShpToWkb {
    public static void main(String[] args) throws ShapefileException, IOException {
        System.out.println(ShpToWkb.shpToWkb(args[0]));
    }

    public static String shpToWkb(String file) throws MalformedURLException, IOException, ShapefileException {
        ShpFiles shpFiles = new ShpFiles(file);
        ShapefileReader shapefileReader = new ShapefileReader(shpFiles, true, true, new GeometryFactory(), false);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        while (shapefileReader.hasNext()) {
            Geometry geometry = (Geometry)shapefileReader.nextRecord().shape();
            pw.println(WKBWriter.toHex(new WKBWriter().write(geometry)));
        }
        shapefileReader.close();
        pw.flush();
        pw.close();
        return sw.toString();
    }

    public static List<ImmutableGeoObject> shpToImmutableGeoObjects(String file, CoordinateFactory coordinateFactory) throws MalformedURLException, IOException, ShapefileException {
        ShpFiles shpFiles = new ShpFiles(file);
        ShapefileReader shapefileReader = new ShapefileReader(shpFiles, true, true, new GeometryFactory(), false);
        LinkedList<ImmutableGeoObject> list = new LinkedList<ImmutableGeoObject>();
        while (shapefileReader.hasNext()) {
            Geometry geometry = (Geometry)shapefileReader.nextRecord().shape();
            list.add(ImmutableGeoObjectFactory.createImmutableGeoObject(geometry, coordinateFactory));
        }
        shapefileReader.close();
        return list;
    }
}

