/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.command;

import de.datomino.util.command.Type;
import de.datomino.util.command.shp.WkbToShp;
import de.datomino.util.geo.ImmutableGeoObject;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.math.projection.Wgs84Factory;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;
import org.xBaseJ.DBF;
import org.xBaseJ.fields.CharField;
import org.xBaseJ.fields.DateField;
import org.xBaseJ.fields.Field;
import org.xBaseJ.fields.LogicalField;
import org.xBaseJ.fields.MemoField;
import org.xBaseJ.fields.NumField;
import org.xBaseJ.fields.PictureField;
import org.xBaseJ.xBaseJException;

public class ShpDbfWriter {
    private static final String WGS84_PRJ = "GEODCRS[\"WGS 84\",\n  DATUM[\"World Geodetic System 1984\",\n    ELLIPSOID[\"WGS 84\",6378137,298.257223563,LENGTHUNIT[\"metre\",1.0]]],\n  CS[ellipsoidal,2],\n    AXIS[\"latitude\",north,ORDER[1]],\n    AXIS[\"longitude\",east,ORDER[2]],\n    ANGLEUNIT[\"degree\",0.01745329252],\n  ID[\"EPSG\",4326]]\n";
    private static final String POTSDAM_PRJ = "PROJCS[\"Germany_Zone_3\",GEOGCS[\"GCS_DHDN\",DATUM[\"D_Deutsches_Hauptdreiecksnetz\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0],UNIT[\"Degree\",0.017453292519943295]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",3500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",9.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0]]";

    public static Shp writeShapeWithDbf(String prefix, String[] headers, List<? extends ImmutableGeoObject> geoObjects, List<Object[]> attributes, Type[] types, boolean force) throws IOException, SecurityException, xBaseJException {
        File prj = ShpDbfWriter.createPrj(prefix, geoObjects);
        File file = ShpDbfWriter.writeDbf(prefix, headers, attributes, types, force);
        Tupel<File, File> tupel = WkbToShp.geomsToShp(prefix, geoObjects);
        return new Shp(prj, file, tupel.getElement1(), tupel.getElement2());
    }

    private static File createPrj(String prefix, List<? extends ImmutableGeoObject> geoObjects) throws IOException {
        CoordinateFactory coordinateFactory = null;
        if (geoObjects.isEmpty()) {
            coordinateFactory = Wgs84Factory.INSTANCE;
        } else {
            for (ImmutableGeoObject immutableGeoObject : geoObjects) {
                CoordinateFactory singleCoordinateFactory = immutableGeoObject.getCoordinateFactory();
                if (coordinateFactory == null) {
                    coordinateFactory = singleCoordinateFactory;
                    continue;
                }
                if (new EqualsBuilder().append(coordinateFactory, singleCoordinateFactory).isEquals()) continue;
                coordinateFactory = null;
                break;
            }
        }
        if (coordinateFactory != null) {
            File file = null;
            switch (((CoordinateFactory)coordinateFactory).getProjection()) {
                case Wgs84: {
                    file = new File(prefix + ".prj");
                    FileUtils.writeStringToFile(file, WGS84_PRJ);
                    break;
                }
                case Potsdam: 
                case GaussKrueger: 
                case Mercator: {
                    file = new File(prefix + ".prj");
                    FileUtils.writeStringToFile(file, POTSDAM_PRJ);
                    break;
                }
            }
            return file;
        }
        return null;
    }

    private static File writeDbf(String prefix, String[] headers, List<Object[]> attributes, Type[] types, boolean force) throws IOException, xBaseJException {
        File file = new File(prefix + ".dbf");
        if (!force && file.exists()) {
            throw new IOException();
        }
        file.delete();
        DBF dbf = new DBF(file.getCanonicalPath(), true);
        int[] maxLength = new int[headers.length];
        for (Object[] row : attributes) {
            block27: for (int i = 0; i < headers.length; ++i) {
                Object value = row[i];
                Type type = types[i];
                switch (type) {
                    case CHAR: {
                        String sValue = (String)value;
                        maxLength[i] = Math.max(maxLength[i], sValue == null ? 0 : sValue.length());
                        continue block27;
                    }
                    case DATE: {
                        continue block27;
                    }
                    case FLOAT: {
                        Float fValue = (Float)value;
                        if (fValue == null) continue block27;
                        int d = Math.round(fValue.floatValue());
                        maxLength[i] = Math.max(maxLength[i], Integer.toString(d).length());
                        continue block27;
                    }
                    case LOGICAL: {
                        continue block27;
                    }
                    case MEMO: {
                        continue block27;
                    }
                    case NUM: {
                        continue block27;
                    }
                }
            }
        }
        Field[] fields = new Field[headers.length];
        for (int i = 0; i < headers.length; ++i) {
            String header = headers[i];
            Type type = types[i];
            Field field = null;
            switch (type) {
                case CHAR: {
                    field = new CharField(header, Math.max(1, maxLength[i]));
                    break;
                }
                case DATE: {
                    field = new DateField(header);
                    break;
                }
                case FLOAT: {
                    int d = 18 - Math.max(1, maxLength[i]);
                    d = Math.max(d, 2);
                    field = new NonLocaleFloatField(header, 19, d);
                    break;
                }
                case LOGICAL: {
                    field = new LogicalField(header);
                    break;
                }
                case MEMO: {
                    field = new MemoField(header);
                    break;
                }
                case NUM: {
                    field = new NumField(header, 19, 0);
                    break;
                }
                case PICTURE: {
                    field = new PictureField(header);
                }
            }
            dbf.addField(field);
            fields[i] = field;
        }
        for (Object[] row : attributes) {
            block30: for (int i = 0; i < headers.length; ++i) {
                Object value = row[i];
                Type type = types[i];
                Field field = dbf.getField(i + 1);
                switch (type) {
                    case CHAR: {
                        String sValue = (String)value;
                        field.put(StringUtil.nullToEmpty(sValue));
                        continue block30;
                    }
                    case DATE: {
                        Date dValue = (Date)value;
                        if (dValue == null) {
                            field.put("");
                            continue block30;
                        }
                        ((DateField)field).put(dValue);
                        continue block30;
                    }
                    case FLOAT: {
                        Float fValue = (Float)value;
                        if (fValue == null) {
                            field.put("");
                            continue block30;
                        }
                        ((NonLocaleFloatField)field).put(fValue.floatValue());
                        continue block30;
                    }
                    case LOGICAL: {
                        Boolean bValue = (Boolean)value;
                        if (bValue == null) {
                            field.put("");
                            continue block30;
                        }
                        ((LogicalField)field).put(bValue);
                        continue block30;
                    }
                    case MEMO: {
                        String sValue = (String)value;
                        field.put(StringUtil.nullToEmpty(sValue));
                        continue block30;
                    }
                    case NUM: {
                        Number number = (Number)value;
                        if (number == null) {
                            field.put("");
                            continue block30;
                        }
                        ((NumField)field).put(number == null ? null : Long.valueOf(number.longValue()));
                        continue block30;
                    }
                    case PICTURE: {
                        byte[] bytes = (byte[])value;
                        ((PictureField)field).put(bytes == null ? new byte[]{} : bytes);
                    }
                }
            }
            dbf.write();
        }
        dbf.close();
        ShpDbfWriter.cleanFile(file);
        return file;
    }

    private static void cleanFile(File file) throws IOException {
        byte[] b = FileUtils.readFileToByteArray(file);
        int cut = -1;
        for (int i = 0; i < b.length; ++i) {
            if (b[i] != 26) continue;
            cut = i;
        }
        if (cut >= 0) {
            byte[] n = new byte[cut + 1];
            System.arraycopy(b, 0, n, 0, cut + 1);
            FileUtils.writeByteArrayToFile(file, n);
        }
    }

    public static class Shp {
        private File prj;
        private File dbf;
        private File shp;
        private File shx;

        public Shp(File prj, File dbf, File shp, File shx) {
            this.prj = prj;
            this.dbf = dbf;
            this.shp = shp;
            this.shx = shx;
        }

        public File getPrj() {
            return this.prj;
        }

        public File getDbf() {
            return this.dbf;
        }

        public File getShp() {
            return this.shp;
        }

        public File getShx() {
            return this.shx;
        }
    }

    private static class NonLocaleFloatField
    extends NumField {
        private static final long serialVersionUID = 1L;
        private byte decPosition = 0;
        public static final char type = 'F';

        public NonLocaleFloatField(String iName, int iLength, int DecPoint) throws xBaseJException, IOException {
            super(iName, iLength, DecPoint);
            this.decPosition = (byte)DecPoint;
        }

        @Override
        public char getType() {
            return 'F';
        }

        @Override
        public void put(String inValue) throws xBaseJException {
            int i;
            boolean signOn = false;
            if (inValue.trim().length() == 0) {
                super.put("");
                return;
            }
            for (i = 0; i < inValue.length(); ++i) {
                if (inValue.charAt(i) == '-') {
                    signOn = true;
                }
                if (Character.isDigit(inValue.charAt(i)) || inValue.charAt(i) == '.') break;
            }
            if (i == inValue.length()) {
                super.put(" ");
                return;
            }
            int start = i;
            while (i < inValue.length() && (Character.isDigit(inValue.charAt(i)) || inValue.charAt(i) == '.')) {
                ++i;
            }
            String workstring = inValue.substring(start, i);
            char[] charray = new char[this.Length];
            Double inDouble = new Double(workstring);
            double duble = inDouble;
            for (i = 0; i < this.decPosition; ++i) {
                duble *= 10.0;
            }
            inDouble = new Double(duble + 0.01);
            long longv = inDouble.longValue();
            if (longv < 0L) {
                longv *= -1L;
                signOn = true;
            }
            int realdp = this.Length - this.decPosition;
            String numstring = new String("0123456789");
            for (i = this.Length; i > 0; --i) {
                if (realdp == i && this.decPosition > 0) {
                    charray[i - 1] = 46;
                    continue;
                }
                long longleft = longv % 10L;
                int whatsleft = (int)longleft;
                if (whatsleft < 0) {
                    whatsleft *= -1;
                }
                charray[i - 1] = numstring.charAt(whatsleft);
                longv /= 10L;
            }
            if (signOn) {
                charray[0] = 45;
            }
            for (i = 0; i < charray.length - 1 && charray[i] == '0'; ++i) {
                charray[i] = 32;
            }
            super.put(new String(charray));
        }

        @Override
        public void put(long inValue) throws xBaseJException {
            this.put(String.valueOf(inValue));
        }

        @Override
        public void put(int inValue) throws xBaseJException {
            this.put(String.valueOf(inValue));
        }

        @Override
        public void put(float inValue) throws xBaseJException {
            this.put(String.valueOf(inValue));
        }

        @Override
        public void put(double inValue) throws xBaseJException {
            double d = inValue;
            double d10 = Math.pow(10.0, this.Length - this.decPosition);
            d %= d10;
            d10 = Math.pow(0.1, this.decPosition + 1);
            if (d > 0.0) {
                d += d10;
            }
            if (d < 0.0) {
                d -= d10;
            }
            this.put(String.valueOf(d));
        }
    }
}

