/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.collection;

import de.datomino.util.collection.InvalidIntervalOrderException;
import de.datomino.util.collection.Transformer;
import de.datomino.util.collection.TransformerWithException;
import de.datomino.util.common.PrimitiveUtil;
import de.datomino.util.reflection.ReflectionUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.ComparatorUtils;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Quint;
import org.ktde.util.datatypes.Tupel;

public final class CollectionUtil {
    private CollectionUtil() {
    }

    public static <T> T findMin(Collection<T> collection, Comparator<T> comparator) {
        return CollectionUtil.findExtrem(collection, comparator, Extrem.MIN);
    }

    public static <T> T findMax(Collection<T> collection, Comparator<T> comparator) {
        return CollectionUtil.findExtrem(collection, comparator, Extrem.MAX);
    }

    private static <T> T findExtrem(Collection<T> collection, Comparator<T> comparator, Extrem extrem) {
        Object ex = null;
        Iterator<T> iter = collection.iterator();
        if (iter.hasNext()) {
            ex = iter.next();
            while (iter.hasNext()) {
                T next = iter.next();
                switch (extrem) {
                    case MAX: {
                        ex = ComparatorUtils.max(ex, next, comparator);
                        break;
                    }
                    case MIN: {
                        ex = ComparatorUtils.min(ex, next, comparator);
                    }
                }
            }
        }
        return (T)ex;
    }

    public static <T> List<T> findMins(Collection<T> collection, Comparator<T> comparator) {
        Object next;
        if (collection == null) {
            return null;
        }
        if (collection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<T> list = new ArrayList<T>(collection);
        Collections.sort(list, comparator);
        Iterator iterator = list.iterator();
        Object first = iterator.next();
        int lastIndex = 1;
        while (iterator.hasNext() && comparator.compare(first, next = iterator.next()) == 0) {
            ++lastIndex;
        }
        return list.subList(0, lastIndex);
    }

    public static <T> List<T> findMaxs(Collection<T> collection, Comparator<T> comparator) {
        return CollectionUtil.findMins(collection, ComparatorUtils.reversedComparator(comparator));
    }

    public static <T> ArrayList<T> buildArrayList(T ... ts) {
        ArrayList list = new ArrayList(ts.length);
        return CollectionUtil.buildList(list, ts);
    }

    public static <T> ArrayList<T> buildArrayList(int size, T t) {
        ArrayList<T> list = new ArrayList<T>(size);
        for (int i = 0; i < size; ++i) {
            list.add(i, t);
        }
        return list;
    }

    public static <T> LinkedList<T> buildLinkedList(T ... ts) {
        LinkedList list = new LinkedList();
        return CollectionUtil.buildList(list, ts);
    }

    private static <T, U extends List<T>> U buildList(U u, T ... ts) {
        for (T t : ts) {
            u.add(t);
        }
        return u;
    }

    public static <T, U> void transform(Collection<T> source, Collection<U> target, Transformer<T, U> transformer) {
        for (T t : source) {
            target.add(transformer.transform(t));
        }
    }

    public static <T, U, E extends Exception> void transform(Collection<T> source, Collection<U> target, TransformerWithException<T, U, E> transformer) throws E {
        for (T t : source) {
            target.add(transformer.transform(t));
        }
    }

    public static <T> List<T> shiftLeft(List<T> list) {
        if (list.size() > 1) {
            List<T> result = list.subList(1, list.size());
            result.add(list.get(0));
            return result;
        }
        return new ArrayList<T>(list);
    }

    public static <T> Set<T> buildHashSet(T ... ts) {
        HashSet<T> set = new HashSet<T>();
        for (T t : ts) {
            set.add(t);
        }
        return set;
    }

    public static <T> boolean isEqualsCollection(Collection<T> a, Collection<T> b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return CollectionUtils.isEqualCollection(a, b);
    }

    public static <T> Collection<T> flatCollection(Collection<? extends Collection<T>> collection, boolean set) {
        if (collection == null) {
            return null;
        }
        AbstractCollection result = set ? new HashSet() : new LinkedList();
        for (Collection<T> subCollection : collection) {
            result.addAll(subCollection);
        }
        return result;
    }

    public static <T> List<T> getNextFromIterator(Iterator<? extends T> iter, int count) {
        ArrayList<T> list = new ArrayList<T>(count);
        for (int i = 0; i < count && iter.hasNext(); ++i) {
            list.add(iter.next());
        }
        return list;
    }

    public static <T> List<T> iterableToList(Iterable<T> iterable) {
        LinkedList<T> list = new LinkedList<T>();
        for (T t : iterable) {
            list.add(t);
        }
        return list;
    }

    public static <T, S> Map<S, T> mapize(Class<T> clazz, Collection<T> objects, String property) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method method = clazz.getMethod("get" + StringUtil.capitalize(property), new Class[0]);
        HashMap<Object, T> map = new HashMap<Object, T>();
        for (T object : objects) {
            Object s = method.invoke(object, new Object[0]);
            map.put(s, object);
        }
        return map;
    }

    public static <T extends Comparable<T>> T findMin(Collection<T> ts) {
        if (ts.isEmpty()) {
            return null;
        }
        Iterator<T> iter = ts.iterator();
        Comparable min = (Comparable)iter.next();
        while (iter.hasNext()) {
            Comparable next = (Comparable)iter.next();
            if (min.compareTo(next) <= 0) continue;
            min = next;
        }
        return (T)min;
    }

    public static <T extends Comparable<T>> T findMax(Collection<T> ts) {
        if (ts.isEmpty()) {
            return null;
        }
        Iterator<T> iter = ts.iterator();
        Comparable max = (Comparable)iter.next();
        while (iter.hasNext()) {
            Comparable next = (Comparable)iter.next();
            if (max.compareTo(next) >= 0) continue;
            max = next;
        }
        return (T)max;
    }

    public static <T> T getLastElement(List<T> list) {
        if (list.isEmpty()) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    public static <T, S extends Comparable<S>> List<T> orderByIntervals(Collection<T> values, final String propStart, String propEnd) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, InvalidIntervalOrderException {
        ArrayList<T> list = new ArrayList<T>(values);
        if (!list.isEmpty()) {
            try {
                Collections.sort(list, new Comparator<T>(){

                    @Override
                    public int compare(T o1, T o2) {
                        try {
                            Comparable c1 = (Comparable)ReflectionUtil.getPropertyValue(o1, propStart);
                            Comparable c2 = (Comparable)ReflectionUtil.getPropertyValue(o2, propStart);
                            if (c1 == c2) {
                                return 0;
                            }
                            if (c1 == null) {
                                return -1;
                            }
                            if (c2 == null) {
                                return 1;
                            }
                            return c1.compareTo(c2);
                        }
                        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
            catch (RuntimeException ex) {
                Throwable cause = ex.getCause();
                if (cause instanceof IllegalAccessException) {
                    throw (IllegalAccessException)cause;
                }
                if (cause instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)cause;
                }
                if (cause instanceof InvocationTargetException) {
                    throw (InvocationTargetException)cause;
                }
                throw ex;
            }
            Iterator iter = list.iterator();
            Object pred = iter.next();
            while (iter.hasNext()) {
                Object succ = iter.next();
                Comparable start1 = (Comparable)ReflectionUtil.getPropertyValue(pred, propStart);
                Comparable start2 = (Comparable)ReflectionUtil.getPropertyValue(succ, propStart);
                Comparable end1 = (Comparable)ReflectionUtil.getPropertyValue(pred, propEnd);
                Comparable end2 = (Comparable)ReflectionUtil.getPropertyValue(succ, propEnd);
                if (start1.compareTo(end1) > 0 || start2.compareTo(end2) > 0 || end1.compareTo(start2) > 0 || end2.compareTo(end1) < 0) {
                    throw new InvalidIntervalOrderException();
                }
                pred = succ;
            }
        }
        return list;
    }

    public static <T, S extends Comparable<S>> Quint<T, T, List<T>, T, T> findIntervalEntryPoint(List<T> ordered, String propStart, String propEnd, S entryStart, S entryEnd) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Integer innerEndIndex;
        if (entryStart == null && entryEnd == null) {
            throw new RuntimeException();
        }
        if (ordered.isEmpty()) {
            return new Quint(null, null, Collections.emptyList(), null, null);
        }
        Tupel<Integer, Tupel<Integer, Integer>> hitStart = CollectionUtil.findHit(ordered, propStart, propEnd, entryStart, false);
        Tupel<Integer, Tupel<Integer, Integer>> hitEnd = CollectionUtil.findHit(ordered, propStart, propEnd, entryEnd, true);
        Integer innerStartIndex = hitStart.getElement1();
        Object innerStart = innerStartIndex == null ? null : (Object)ordered.get(innerStartIndex);
        Object outerStart = null;
        Integer outerStartIndex = null;
        if (innerStart == null) {
            outerStartIndex = hitStart.getElement2().getElement1();
            outerStart = outerStartIndex == null ? null : (Object)ordered.get(outerStartIndex);
        }
        Object innerEnd = (innerEndIndex = hitEnd.getElement1()) == null ? null : (Object)ordered.get(innerEndIndex);
        Object outerEnd = null;
        Integer outerEndIndex = null;
        if (innerEnd == null) {
            outerEndIndex = hitEnd.getElement2().getElement2();
            Object x = outerEnd = outerEndIndex == null ? null : (Object)ordered.get(outerEndIndex);
        }
        int middleIndexStart = innerStart == null ? (outerStart == null ? 0 : outerStartIndex + 1) : innerStartIndex + 1;
        int middleIndexEnd = innerEnd == null ? (outerEnd == null ? ordered.size() : outerEndIndex.intValue()) : innerEndIndex;
        return new Quint<Object, Object, List<T>, Object, Object>(outerStart, innerStart, ordered.subList(middleIndexStart, middleIndexEnd), innerEnd, outerEnd);
    }

    private static <T, S extends Comparable<S>> Tupel<Integer, Tupel<Integer, Integer>> findHit(List<T> ordered, String propStart, String propEnd, S entry, boolean last) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Comparable end;
        int lastIndex = ordered.size() - 1;
        if (entry == null) {
            if (last) {
                T lastEntry = ordered.get(lastIndex);
                Comparable end2 = (Comparable)ReflectionUtil.getPropertyValue(lastEntry, propEnd);
                if (end2 == null) {
                    return new Tupel<Integer, Object>(lastIndex, null);
                }
                return new Tupel<Object, Tupel<Integer, Object>>(null, new Tupel<Integer, Object>(lastIndex, null));
            }
            T firstEntry = ordered.get(0);
            Comparable start = (Comparable)ReflectionUtil.getPropertyValue(firstEntry, propStart);
            if (start == null) {
                return new Tupel<Integer, Object>(0, null);
            }
            return new Tupel<Object, Tupel<Object, Integer>>(null, new Tupel<Object, Integer>(null, 0));
        }
        ListIterator<T> iter = ordered.listIterator();
        T pred = iter.next();
        Comparable start = (Comparable)ReflectionUtil.getPropertyValue(pred, propStart);
        if (PrimitiveUtil.isInInterval(entry, null, start, false)) {
            return new Tupel<Object, Tupel<Object, Integer>>(null, new Tupel<Object, Integer>(null, 0));
        }
        while (iter.hasNext()) {
            start = (Comparable)ReflectionUtil.getPropertyValue(pred, propStart);
            if (PrimitiveUtil.isInInterval(entry, start, end = (Comparable)ReflectionUtil.getPropertyValue(pred, propEnd), true)) {
                return new Tupel<Integer, Object>(iter.nextIndex() - 1, null);
            }
            T succ = iter.next();
            Comparable startSucc = (Comparable)ReflectionUtil.getPropertyValue(succ, propStart);
            if (PrimitiveUtil.isInInterval(entry, end, startSucc, false)) {
                int previousIndex = iter.previousIndex() - 1;
                return new Tupel<Object, Tupel<Integer, Integer>>(null, new Tupel<Integer, Integer>(previousIndex, previousIndex + 1));
            }
            pred = succ;
        }
        start = (Comparable)ReflectionUtil.getPropertyValue(pred, propStart);
        if (PrimitiveUtil.isInInterval(entry, start, end = (Comparable)ReflectionUtil.getPropertyValue(pred, propEnd), true)) {
            return new Tupel<Integer, Object>(lastIndex, null);
        }
        return new Tupel<Object, Tupel<Integer, Object>>(null, new Tupel<Integer, Object>(lastIndex, null));
    }

    public static <T, S> Map<T, S> tupelToHashMap(Collection<Tupel<T, S>> tupels) {
        HashMap<T, S> result = new HashMap<T, S>();
        for (Tupel<T, S> tupel : tupels) {
            result.put(tupel.getElement1(), tupel.getElement2());
        }
        return result;
    }

    public static <T, S> void removeFromOnlyFirstMatch(Collection<Tupel<T, S>> col, Collection<Tupel<T, S>> toRemove) {
        final HashSet<T> set = new HashSet<T>();
        for (Tupel<T, S> tupel : toRemove) {
            set.add(tupel.getElement1());
        }
        col.removeIf(new Predicate<Tupel<T, S>>(){

            @Override
            public boolean test(Tupel<T, S> t) {
                return set.contains(t.getElement1());
            }
        });
    }

    public static <T, S> void setifyByFirst(Collection<Tupel<T, S>> col) {
        HashSet<T> set = new HashSet<T>();
        LinkedList<Tupel<T, S>> list = new LinkedList<Tupel<T, S>>();
        for (Tupel<T, S> tupel : col) {
            T t = tupel.getElement1();
            if (set.contains(t)) continue;
            set.add(t);
            list.add(tupel);
        }
        col.clear();
        col.addAll(list);
    }

    private static enum Extrem {
        MAX,
        MIN;

    }
}

