/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.collection;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class ArrayUtil {
    private ArrayUtil() {
    }

    public static int[] transform(byte[] array) {
        if (array == null) {
            return null;
        }
        int[] result = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static byte[] concatArray(Collection<byte[]> collection) {
        List<byte[]> list = ArrayUtil.filterEmpty(collection);
        int size = list.size();
        switch (size) {
            case 0: {
                return new byte[0];
            }
            case 1: {
                return list.get(0);
            }
        }
        int count = 0;
        for (byte[] b : list) {
            count += b.length;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(count);
        for (byte[] b : list) {
            try {
                baos.write(b);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return baos.toByteArray();
    }

    private static List<byte[]> filterEmpty(Collection<byte[]> collection) {
        ArrayList<byte[]> list = new ArrayList<byte[]>(collection.size());
        for (byte[] b : collection) {
            if (b.length == 0) continue;
            list.add(b);
        }
        return list;
    }
}

