/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.assistant.model;

import de.datomino.util.assistant.model.Field;
import de.datomino.util.assistant.model.Page;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;

public class Wizard {
    private String title;
    private List<Page> pages;

    public Wizard(String title) {
        this.title = title;
        this.pages = new LinkedList<Page>();
    }

    public Wizard(String title, List<Page> pages) {
        this.title = title;
        this.pages = pages;
    }

    public void addPage(Page page) {
        this.pages.add(page);
    }

    public String getTitle() {
        return this.title;
    }

    public List<Page> getPages() {
        return Collections.unmodifiableList(this.pages);
    }

    public Collection<Field<?>> getFields() {
        LinkedHashSet set = new LinkedHashSet();
        for (Page page : this.pages) {
            set.addAll(page.getFields());
        }
        return Collections.unmodifiableSet(set);
    }

    public int countPages() {
        return this.pages.size();
    }

    public Page getPageAt(int index) {
        return this.pages.get(index);
    }
}

