/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.assistant.model;

import de.datomino.util.assistant.model.ChoiceField;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ktde.util.NameGenerator;
import org.ktde.util.StringUtil;
import org.ktde.util.ToStringNameGenerator;

public class CsvColumnChoiceField
extends ChoiceField<String> {
    private Serializable canonicalName;
    private Pattern regex;
    private boolean optional;

    public CsvColumnChoiceField(String title, Serializable canonicalName, String regex, boolean optional) {
        super(title, (T[])new String[]{null}, new ToStringNameGenerator("_nicht verf\u00fcgbar"));
        this.canonicalName = canonicalName;
        try {
            this.regex = Pattern.compile(regex == null ? "^" + canonicalName.toString() + "$" : regex, 2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.optional = optional;
    }

    public void setColumns(List<String> line) {
        int opt = this.optional ? 1 : 0;
        String[] choices = new String[line.size() + opt];
        if (opt == 1) {
            choices[0] = "_nicht verwendet";
        }
        int i = opt;
        String matched = null;
        if (this.regex != null) {
            for (String string : line) {
                choices[i++] = string;
                Matcher matcher = this.regex.matcher(string);
                if (!matcher.matches()) continue;
                matched = string;
            }
        }
        this.setChoices(choices);
        if (matched != null) {
            this.setValue(matched);
        }
    }

    public Serializable getCanonicalName() {
        return this.canonicalName;
    }

    @Override
    public String getTitle() {
        String title = super.getTitle();
        if (!this.optional) {
            title = title + "*";
        }
        return title;
    }

    public static String createRegex(String ... regs) {
        if (regs.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder("^(?:");
        ArrayList<String> regList = new ArrayList<String>(regs.length * 2);
        for (String reg : regs) {
            regList.add(reg);
            regList.add(reg + "*");
        }
        String chain = StringUtil.implode(regList, "|", new NameGenerator<String>(){

            @Override
            public String getName(String t) {
                return Pattern.quote(t);
            }
        });
        sb.append(chain).append(")$");
        return sb.toString();
    }

    public static String createRegexForXCoordinate() {
        return CsvColumnChoiceField.createRegex("x", "lon", "longitude", "wgsx", "xwgs", "Haus-Koordinate-X", "GCO X", "Koordinate x");
    }

    public static String createRegexForYCoordinate() {
        return CsvColumnChoiceField.createRegex("y", "lat", "latitude", "wgsy", "ywgs", "Haus-Koordinate-Y", "GCO Y", "Koordinate y");
    }
}

