/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.assistant.model;

import de.datomino.util.assistant.editor.DropdownEditor;
import de.datomino.util.assistant.model.AbstractField;
import java.util.Collection;
import org.ktde.util.NameGenerator;
import org.ktde.util.ToStringNameGenerator;

public class ChoiceField<T>
extends AbstractField<T> {
    private T[] choices;
    private NameGenerator<T> nameGenerator;

    public ChoiceField(String title, Collection<T> choices, NameGenerator<T> nameGenerator) {
        super(title, new DropdownEditor(), choices == null || choices.isEmpty() ? null : (Object)choices.iterator().next());
        Object[] choicesA = choices.toArray();
        this.choices = choicesA;
        this.nameGenerator = nameGenerator;
    }

    public ChoiceField(String title, Collection<T> choices) {
        this(title, choices, (T)new ToStringNameGenerator());
    }

    public ChoiceField(String title, Collection<T> choices, NameGenerator<T> nameGenerator, T defaultValue) {
        super(title, new DropdownEditor(), defaultValue);
        Object[] choicesA = choices.toArray();
        this.choices = choicesA;
        this.nameGenerator = nameGenerator;
    }

    public ChoiceField(String title, Collection<T> choices, T defaultValue) {
        this(title, choices, new ToStringNameGenerator(), defaultValue);
    }

    public ChoiceField(String title, T[] choices, NameGenerator<T> nameGenerator) {
        super(title, new DropdownEditor());
        this.choices = choices;
        this.nameGenerator = nameGenerator;
    }

    public ChoiceField(String title, T[] choices) {
        this(title, choices, (T)new ToStringNameGenerator());
    }

    public ChoiceField(String title, T[] choices, NameGenerator<T> nameGenerator, T defaultValue) {
        super(title, new DropdownEditor(), defaultValue);
        this.choices = choices;
        this.nameGenerator = nameGenerator;
    }

    public ChoiceField(String title, T[] choices, T defaultValue) {
        this(title, choices, new ToStringNameGenerator(), defaultValue);
    }

    public void setChoices(T[] choices) {
        this.choices = choices;
        this.fireChangeEvent(null);
    }

    public void setChoices(Collection<T> choices) {
        Object[] choicesA = choices.toArray();
        this.setChoices(choicesA);
    }

    public T[] getChoices() {
        return this.choices;
    }

    public NameGenerator<T> getNameGenerator() {
        return this.nameGenerator;
    }
}

