/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.assistant.editor;

import de.datomino.util.assistant.editor.AbstractFieldsetPanel;
import de.datomino.util.assistant.editor.Editor;
import de.datomino.util.assistant.model.Field;
import de.datomino.util.assistant.model.Fieldset;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.ktde.swing.ButtonBox;
import org.ktde.util.datatypes.Tripel;

public class FieldsetPanel
extends AbstractFieldsetPanel {
    private static final long serialVersionUID = -2053341644587902696L;
    private Fieldset fieldset;

    public FieldsetPanel(Fieldset fieldset) {
        super(new BorderLayout());
        List<Action> actions2 = fieldset.getActions();
        JPanel widgetPanel = new JPanel();
        this.add((Component)widgetPanel, "North");
        if (!actions2.isEmpty()) {
            ButtonBox box = new ButtonBox();
            for (Action action : actions2) {
                box.add(new JButton(action));
            }
            this.add((Component)box, "South");
        }
        this.fieldset = fieldset;
        this.createGroup(widgetPanel);
        String title = fieldset.getTitle();
        if (title != null) {
            this.setBorder(new TitledBorder(title));
        }
    }

    @Override
    protected List<Tripel<Component, String, Boolean>> extractElements() {
        LinkedList<Tripel<Component, String, Boolean>> elements = new LinkedList<Tripel<Component, String, Boolean>>();
        for (Field<?> field : this.fieldset.getFields()) {
            Editor<?, Field<?>> editor = field.getEditor();
            elements.add(new Tripel<Component, String, Boolean>(editor.createComponent(field), field.getTitle(), editor.needsTitle()));
        }
        return elements;
    }
}

