/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.assistant.editor;

import de.datomino.util.assistant.editor.AbstractEditor;
import de.datomino.util.assistant.model.ChoiceField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.apache.commons.lang.ArrayUtils;
import org.ktde.model.ValueChangeEvent;
import org.ktde.model.ValueChangeListener;
import org.ktde.util.NameGenerator;
import org.ktde.util.datatypes.Tripel;

public class DropdownEditor<T>
extends AbstractEditor<T, ChoiceField<T>, JComboBox, JComboBox, JComboBox> {
    private ChoiceField<T> field;
    private T[] choices;
    private NameGenerator<T> nameGenerator;
    private T selected;
    private Dimension preferredSize;

    @Override
    public boolean needsTitle() {
        return true;
    }

    @Override
    protected Tripel<JComboBox, JComboBox, JComboBox> createOuterComponent(ChoiceField<T> field) {
        this.field = field;
        this.choices = field.getChoices();
        this.nameGenerator = field.getNameGenerator();
        JComboBox comboBox = new JComboBox(new ComboBoxModel());
        Object element = field.getValue();
        if (element != null) {
            comboBox.setSelectedItem(element);
        } else if (comboBox.getItemCount() > 0) {
            comboBox.setSelectedIndex(0);
        }
        if (this.preferredSize == null) {
            this.preferredSize = comboBox.getPreferredSize();
        }
        comboBox.setPreferredSize(this.preferredSize);
        comboBox.addActionListener(new AbstractEditor.EditorActionListener());
        comboBox.setRenderer(new ComboBoxRenderer());
        return new Tripel<JComboBox, JComboBox, JComboBox>(comboBox, comboBox, comboBox);
    }

    @Override
    protected T getValueFromComponent(JComboBox component) {
        return (T)component.getSelectedItem();
    }

    @Override
    protected void setValueInComponent(T value, JComboBox component) {
        component.setSelectedItem(value);
    }

    static /* synthetic */ Object[] access$202(DropdownEditor x0, Object[] x1) {
        x0.choices = x1;
        return x1;
    }

    public class ComboBoxRenderer
    implements ListCellRenderer {
        private Map<Integer, DefaultListCellRenderer> rendererCache = new LinkedHashMap<Integer, DefaultListCellRenderer>();

        private ComboBoxRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String s;
            DefaultListCellRenderer delegate = this.rendererCache.get(index);
            if (delegate == null) {
                delegate = new DefaultListCellRenderer();
                this.rendererCache.put(index, delegate);
            }
            boolean disabled = false;
            try {
                Object t = value;
                s = DropdownEditor.this.nameGenerator.getName(t);
            }
            catch (ClassCastException cce) {
                s = value.toString();
            }
            if (s != null && s.startsWith("_")) {
                disabled = true;
                s = "-- " + s.substring(1) + " --";
            }
            Component c = delegate.getListCellRendererComponent((JList<?>)list, s, index, isSelected, cellHasFocus);
            if (disabled) {
                c.setForeground(Color.GRAY);
            } else {
                c.setForeground(Color.BLACK);
            }
            return c;
        }
    }

    public class ComboBoxModel
    extends AbstractListModel
    implements javax.swing.ComboBoxModel,
    ValueChangeListener {
        private static final long serialVersionUID = 7360397943469566351L;

        public ComboBoxModel() {
            DropdownEditor.this.field.addValueChangeListener(this);
        }

        @Override
        public int getSize() {
            return DropdownEditor.this.choices.length;
        }

        @Override
        public Object getElementAt(int index) {
            return DropdownEditor.this.choices[index];
        }

        @Override
        public void setSelectedItem(Object anItem) {
            DropdownEditor.this.selected = anItem;
            this.fireContentsChanged(this, -1, -1);
        }

        @Override
        public Object getSelectedItem() {
            return DropdownEditor.this.selected;
        }

        @Override
        public void valueChanged(ValueChangeEvent e) {
            Object[] newChoices = DropdownEditor.this.field.getChoices();
            if (DropdownEditor.this.choices != newChoices) {
                DropdownEditor.access$202(DropdownEditor.this, newChoices);
                if (!ArrayUtils.contains(newChoices, DropdownEditor.this.selected) && newChoices.length > 0) {
                    this.setSelectedItem(newChoices[0]);
                }
            }
        }
    }
}

