/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.assistant.editor;

import de.datomino.util.assistant.editor.Editor;
import de.datomino.util.assistant.model.Field;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.ktde.model.ValueChangeEvent;
import org.ktde.model.ValueChangeListener;
import org.ktde.util.datatypes.Tripel;

public abstract class AbstractEditor<T, S extends Field<T>, C extends Component, CV extends Component, CF extends Component>
implements Editor<T, S> {
    private Field<T> field;
    private C component;
    private CF focusableComponent;
    private CV valueComponent;

    public final C createComponent(S field) {
        this.field = field;
        EditorValueChangeListener listener = new EditorValueChangeListener();
        field.addValueChangeListener(listener);
        Tripel<C, CF, CV> tripel = this.createOuterComponent(field);
        this.component = (Component)tripel.getElement1();
        this.focusableComponent = (Component)tripel.getElement2();
        this.valueComponent = (Component)tripel.getElement3();
        return this.component;
    }

    public final CF getFocusableComponent() {
        return this.focusableComponent;
    }

    public final C getComponent() {
        return this.component;
    }

    protected abstract Tripel<C, CF, CV> createOuterComponent(S var1);

    protected abstract T getValueFromComponent(CV var1);

    protected abstract void setValueInComponent(T var1, CV var2);

    protected T getValueFromComponent() {
        return this.getValueFromComponent(this.valueComponent);
    }

    protected void setValueInComponent(T value) {
        this.setValueInComponent(value, this.valueComponent);
    }

    protected T getValue() {
        return this.field.getValue();
    }

    protected void setValue(T value) {
        this.field.setValue(value);
    }

    @Override
    public void setEnabled(boolean b) {
        ((Component)this.component).setEnabled(b);
    }

    public class EditorFocusListener
    implements FocusListener {
        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            AbstractEditor.this.field.setValue(AbstractEditor.this.getValueFromComponent());
        }
    }

    public class EditorChangeListener
    implements ChangeListener {
        @Override
        public void stateChanged(ChangeEvent e) {
            AbstractEditor.this.field.setValue(AbstractEditor.this.getValueFromComponent());
        }
    }

    public class EditorActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractEditor.this.field.setValue(AbstractEditor.this.getValueFromComponent());
        }
    }

    public class EditorValueChangeListener
    implements ValueChangeListener {
        @Override
        public void valueChanged(ValueChangeEvent e) {
            AbstractEditor.this.setValueInComponent(AbstractEditor.this.field.getValue());
        }
    }
}

