/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.algorithm.tsp;

import de.datomino.util.algorithm.ComputeStopTime;
import de.datomino.util.algorithm.tsp.AbstractTsp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.ktde.util.datatypes.Tupel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExactTsp<T>
extends AbstractTsp<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExactTsp.class);
    private boolean interupted = false;
    private boolean canWait;

    public ExactTsp(Map<T, Collection<Tupel<T, Double>>> adjacencyLists, Map<T, Collection<Tupel<Double, Double>>> wayLimits, Map<T, Double> stopWeight, T startPoint, T endPoint) {
        this(adjacencyLists, wayLimits, stopWeight, startPoint, endPoint, false);
    }

    public ExactTsp(Map<T, Collection<Tupel<T, Double>>> adjacencyLists, Map<T, Collection<Tupel<Double, Double>>> wayLimits, Map<T, Double> stopWeight, T startPoint, T endPoint, boolean canWait) {
        super(adjacencyLists, wayLimits, stopWeight, startPoint, endPoint);
        this.canWait = canWait;
    }

    @Override
    protected List<Integer> perform(Double[][] matrix, Map<Integer, Collection<Tupel<Double, Double>>> limits, Map<Integer, Double> stopWeight, Integer startPointIndex, Integer endPointIndex) {
        Tupel<List<Integer>, Double> solution = this.rek(matrix, limits, stopWeight, new Stack<Integer>(), 0.0, null, startPointIndex, endPointIndex);
        this.finishStep();
        return solution == null ? null : solution.getElement1();
    }

    @Override
    protected int preCalcSteps(Double[][] matrix, Map<Integer, Collection<Tupel<Double, Double>>> limits, Map<Integer, Double> stopWeight) {
        return 1;
    }

    private Tupel<List<Integer>, Double> rek(Double[][] matrix, Map<Integer, Collection<Tupel<Double, Double>>> limits, Map<Integer, Double> stopWeight, Stack<Integer> currentSolution, Double currentValue, Double best, Integer startPointIndex, Integer endPointIndex) {
        Tupel<List<Integer>, Double> bestSolution = null;
        Integer lastIndex = currentSolution.isEmpty() ? null : currentSolution.peek();
        int eLength = matrix.length - (startPointIndex == null ? 0 : 1) - (endPointIndex == null ? 0 : 1);
        if (currentSolution.size() == eLength) {
            double end = 0.0;
            if (endPointIndex != null) {
                end = matrix[lastIndex][endPointIndex];
            }
            ArrayList<Integer> solutionList = new ArrayList<Integer>(currentSolution);
            double solutionValue = currentValue + end;
            bestSolution = new Tupel<ArrayList<Integer>, Double>(solutionList, solutionValue);
            LOGGER.debug("Current best solution: " + solutionValue);
        } else {
            List<IndexAndDist> order = this.orderStops(matrix, currentSolution, startPointIndex, endPointIndex, lastIndex);
            for (IndexAndDist indexAndDist : order) {
                double newCurrentValue;
                int i = indexAndDist.getIndex();
                if (this.interupted) break;
                double toAdd = indexAndDist.getDist();
                Double duration = stopWeight.get(i);
                double newCurrentValueExit = newCurrentValue = currentValue + toAdd;
                if (duration == null) {
                    duration = 0.0;
                } else {
                    newCurrentValueExit += duration.doubleValue();
                }
                if (best != null && !(newCurrentValueExit < best)) continue;
                boolean matched = false;
                if (!this.canWait) {
                    matched = this.isInLimits(newCurrentValue, newCurrentValueExit, limits.get(i));
                } else {
                    Double deviation = ComputeStopTime.getLimitDeviation(newCurrentValue, duration, limits.get(i));
                    if (deviation != null) {
                        matched = true;
                        newCurrentValue += deviation.doubleValue();
                        newCurrentValueExit += deviation.doubleValue();
                    }
                }
                if (!matched) continue;
                currentSolution.push(i);
                Tupel<List<Integer>, Double> solution = this.rek(matrix, limits, stopWeight, currentSolution, newCurrentValueExit, best, startPointIndex, endPointIndex);
                if (solution != null && (best == null || solution.getElement2() < best)) {
                    bestSolution = solution;
                    best = bestSolution.getElement2();
                }
                currentSolution.pop();
            }
        }
        return bestSolution;
    }

    private List<IndexAndDist> orderStops(Double[][] matrix, Stack<Integer> currentSolution, Integer startPointIndex, Integer endPointIndex, Integer lastIndex) {
        ArrayList<IndexAndDist> list = new ArrayList<IndexAndDist>(matrix.length);
        for (int i = 0; i < matrix.length; ++i) {
            if (currentSolution.contains(i) || startPointIndex != null && startPointIndex == i || endPointIndex != null && endPointIndex == i) continue;
            Double toAdd = lastIndex == null ? (startPointIndex != null ? matrix[startPointIndex][i] : Double.valueOf(0.0)) : matrix[lastIndex][i];
            if (toAdd == null) continue;
            list.add(new IndexAndDist(i, toAdd));
        }
        Collections.sort(list);
        return list;
    }

    private boolean isInLimits(Double newCurrentValue, Double newCurrentValueExit, Collection<Tupel<Double, Double>> tupels) {
        if (tupels == null) {
            return true;
        }
        for (Tupel<Double, Double> tupel : tupels) {
            Double lower = tupel.getElement1();
            Double upper = tupel.getElement2();
            if (lower != null && !(lower <= newCurrentValue) || upper != null && !(upper >= newCurrentValueExit)) continue;
            return true;
        }
        return false;
    }

    public void interrupt() {
        this.interupted = true;
    }

    private static class IndexAndDist
    implements Comparable<IndexAndDist> {
        private int index;
        private double dist;

        public IndexAndDist(int index, double dist) {
            this.index = index;
            this.dist = dist;
        }

        public int getIndex() {
            return this.index;
        }

        public double getDist() {
            return this.dist;
        }

        @Override
        public int compareTo(IndexAndDist o) {
            return Double.valueOf(this.dist).compareTo(o.dist);
        }
    }
}

