/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.algorithm.selfintersection;

import de.datomino.util.geo.ImmutableGeoObject;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutableGeometryCollection;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.ImmutablePolygon;
import de.datomino.util.geo.ImmutablePolygonKind;
import de.datomino.util.geo.exception.IllegalPointCountException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.ktde.util.algorithm.Algorithm;
import org.ktde.util.algorithm.AlgorithmException;
import org.ktde.util.algorithm.InputDataValidationException;
import org.ktde.util.datatypes.Tree;

public class SelfIntersectionKiller
extends Algorithm {
    private Collection<List<ImmutablePoint>> points;
    private ImmutablePolygonKind result;
    private boolean ignoreHoles;

    public SelfIntersectionKiller(Collection<List<ImmutablePoint>> points) {
        this.points = points;
    }

    public SelfIntersectionKiller(Collection<List<ImmutablePoint>> points, boolean ignoreHoles) {
        this.points = points;
        this.ignoreHoles = ignoreHoles;
    }

    @Override
    protected void perform() throws AlgorithmException {
        ImmutablePolygonKind wholePolygon = null;
        try {
            for (List<ImmutablePoint> subPoints : this.points) {
                if (subPoints.size() < 3) continue;
                List<List<ImmutablePoint>> iParts = this.killIntersections(subPoints);
                ImmutablePolygonKind polygon = this.createIntersectionFreePolygon(iParts);
                if (wholePolygon == null) {
                    wholePolygon = polygon;
                    continue;
                }
                wholePolygon = (ImmutablePolygonKind)wholePolygon.union(polygon);
            }
        }
        catch (IllegalPointCountException e) {
            throw new AlgorithmException(e);
        }
        this.result = wholePolygon;
    }

    private ImmutablePolygonKind createIntersectionFreePolygon(List<List<ImmutablePoint>> iParts) throws IllegalPointCountException {
        LinkedList<Tree<ImmutablePolygon>> treeList = new LinkedList<Tree<ImmutablePolygon>>();
        for (List<ImmutablePoint> points : iParts) {
            ImmutablePolygon immutablePolygon = ImmutableGeoObjectFactory.createImmutablePolygon(points);
            boolean found = false;
            for (Tree tree : treeList) {
                Tree.Folder root = tree.getRoot();
                ImmutablePolygon other = (ImmutablePolygon)root.getValue();
                if (immutablePolygon.contains(other)) {
                    root.setValue(immutablePolygon);
                    root.createFolder(other);
                    found = true;
                    break;
                }
                if (!other.contains(immutablePolygon)) continue;
                this.insertIntoTree(root, immutablePolygon);
                found = true;
                break;
            }
            if (found) continue;
            Tree<ImmutablePolygon> tree = new Tree<ImmutablePolygon>(immutablePolygon);
            treeList.add(tree);
        }
        ImmutablePolygonKind multiPolygon = null;
        for (Tree tree : treeList) {
            ImmutablePolygonKind polygon = this.createPolygonFromFolder(tree.getRoot(), false);
            if (multiPolygon == null) {
                multiPolygon = polygon;
                continue;
            }
            ImmutableGeoObject union = multiPolygon.union(polygon);
            if (union instanceof ImmutablePolygonKind) {
                multiPolygon = (ImmutablePolygonKind)union;
                continue;
            }
            if (union instanceof ImmutableGeometryCollection) {
                multiPolygon = ((ImmutableGeometryCollection)union).unionPolygonsToOneMultiPolygon();
                continue;
            }
            throw new RuntimeException("Unexpected geometry type: " + union.getClass());
        }
        return multiPolygon;
    }

    private ImmutablePolygonKind createPolygonFromFolder(Tree.Folder folder, boolean append) {
        ImmutablePolygonKind polygon = (ImmutablePolygon)folder.getValue();
        Iterator<Tree.Node> iter = folder.iterateNodes();
        while (iter.hasNext()) {
            Tree.Folder node = (Tree.Folder)iter.next();
            ImmutablePolygonKind child = this.createPolygonFromFolder(node, !append);
            if (this.ignoreHoles || append) {
                polygon = (ImmutablePolygonKind)polygon.union(child);
                continue;
            }
            polygon = (ImmutablePolygonKind)polygon.difference(child);
        }
        return polygon;
    }

    private void insertIntoTree(Tree.Folder folder, ImmutablePolygon polygon) {
        Iterator<Tree.Node> iter = folder.iterateNodes();
        boolean found = false;
        while (iter.hasNext()) {
            Tree.Folder node = (Tree.Folder)iter.next();
            ImmutablePolygon other = (ImmutablePolygon)node.getValue();
            if (polygon.contains(other)) {
                node.setValue(polygon);
                node.createFolder(other);
                found = true;
                break;
            }
            if (!other.contains(polygon)) continue;
            this.insertIntoTree(node, polygon);
            found = true;
            break;
        }
        if (!found) {
            folder.createFolder(polygon);
        }
    }

    private List<List<ImmutablePoint>> killIntersections(List<ImmutablePoint> points) {
        points = this.filterDoublePoints(points);
        LinkedList<List<ImmutablePoint>> result = new LinkedList<List<ImmutablePoint>>();
        LinkedList<List<ImmutablePoint>> queue = new LinkedList<List<ImmutablePoint>>();
        if (!points.get(0).equals(points.get(points.size() - 1))) {
            points = new ArrayList<ImmutablePoint>(points);
            points.add(points.get(0));
        }
        queue.add(points);
        block0: while (!queue.isEmpty()) {
            List<ImmutablePoint> next = this.normalize((List)queue.poll());
            if (next.size() < 4) continue;
            ListIterator<ImmutablePoint> iter = next.listIterator();
            ImmutablePoint pred = iter.next();
            boolean firstLoop = true;
            while (iter.hasNext()) {
                ImmutablePoint subPred;
                ImmutablePoint succ = iter.next();
                ImmutableLineString lineString = ImmutableGeoObjectFactory.createImmutableLineStringByPoints(pred, succ, new ImmutablePoint[0]);
                int currentIndex = iter.nextIndex() - 1;
                ListIterator<ImmutablePoint> subIter = next.listIterator(currentIndex + 1);
                ImmutablePoint immutablePoint = subPred = subIter.hasNext() ? subIter.next() : null;
                while (subIter.hasNext()) {
                    ImmutablePoint subSucc = subIter.next();
                    if (firstLoop && !subIter.hasNext()) continue;
                    int currentSubIndex = subIter.nextIndex() - 1;
                    ImmutableLineString subLineString = ImmutableGeoObjectFactory.createImmutableLineStringByPoints(subPred, subSucc, new ImmutablePoint[0]);
                    ImmutableGeoObject intersection = lineString.intersection(subLineString);
                    if (intersection instanceof ImmutablePoint) {
                        ImmutablePoint intersectionPoint = (ImmutablePoint)intersection;
                        LinkedList<ImmutablePoint> part1 = new LinkedList<ImmutablePoint>(next.subList(0, currentIndex));
                        part1.add(intersectionPoint);
                        part1.addAll(next.subList(currentSubIndex, next.size()));
                        LinkedList<ImmutablePoint> part2 = new LinkedList<ImmutablePoint>();
                        part2.add(intersectionPoint);
                        part2.addAll(next.subList(currentIndex, currentSubIndex));
                        part2.add(intersectionPoint);
                        queue.add(part1);
                        queue.add(part2);
                        continue block0;
                    }
                    subPred = subSucc;
                }
                firstLoop = false;
                pred = succ;
            }
            result.add(next);
        }
        return result;
    }

    private List<ImmutablePoint> filterDoublePoints(List<ImmutablePoint> points) {
        ArrayList<ImmutablePoint> nPoints = new ArrayList<ImmutablePoint>(points.size());
        Iterator<ImmutablePoint> iter = points.iterator();
        if (iter.hasNext()) {
            ImmutablePoint pred = iter.next();
            nPoints.add(pred);
            while (iter.hasNext()) {
                ImmutablePoint succ = iter.next();
                if (succ.equals(pred)) continue;
                nPoints.add(succ);
                pred = succ;
            }
        }
        return nPoints;
    }

    private List<ImmutablePoint> normalize(List<ImmutablePoint> points) {
        if (points.size() < 2) {
            return points;
        }
        ArrayList<ImmutablePoint> result = new ArrayList<ImmutablePoint>(points.size());
        Iterator<ImmutablePoint> iter = points.iterator();
        ImmutablePoint pred = iter.next();
        result.add(pred);
        while (iter.hasNext()) {
            ImmutablePoint succ = iter.next();
            if (pred.equals(succ)) continue;
            result.add(succ);
            pred = succ;
        }
        return result;
    }

    @Override
    public int preCalcSteps() {
        return 0;
    }

    @Override
    protected void validateInput() throws InputDataValidationException {
    }

    public ImmutablePolygonKind getResult() {
        return this.result;
    }
}

