/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.algorithm.pairfinder.boundline;

import de.datomino.util.algorithm.pairfinder.AbstractPairFinder;
import de.datomino.util.geo.ImmutablePoint;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.ktde.util.datatypes.Tupel;

public class BoundLinePairFinder
extends AbstractPairFinder {
    public BoundLinePairFinder(List<ImmutablePoint> points) {
        super(points);
    }

    @Override
    protected List<Tupel<ImmutablePoint, ImmutablePoint>> calculatePairs(List<ImmutablePoint> points) {
        int size = points.size();
        if (size <= 1) {
            return Collections.emptyList();
        }
        Iterator<ImmutablePoint> iterator = points.iterator();
        if (size == 2) {
            return Collections.singletonList(new Tupel<ImmutablePoint, ImmutablePoint>(iterator.next(), iterator.next()));
        }
        return this.calculateRegular(iterator);
    }

    private List<Tupel<ImmutablePoint, ImmutablePoint>> calculateRegular(Iterator<ImmutablePoint> iterator) {
        ImmutablePoint first;
        LinkedList<Tupel<ImmutablePoint, ImmutablePoint>> list = new LinkedList<Tupel<ImmutablePoint, ImmutablePoint>>();
        ImmutablePoint prev = first = iterator.next();
        while (iterator.hasNext()) {
            ImmutablePoint succ = iterator.next();
            list.add(new Tupel<ImmutablePoint, ImmutablePoint>(prev, succ));
            prev = succ;
        }
        list.add(new Tupel<ImmutablePoint, ImmutablePoint>(prev, first));
        return list;
    }

    @Override
    protected int preCalcSteps(List<ImmutablePoint> points) {
        return points.size();
    }
}

