/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.algorithm.overlaping;

import com.vividsolutions.jts.geom.TopologyException;
import de.datomino.util.algorithm.selfintersection.PolygonSelfIntersectionKiller;
import de.datomino.util.geo.ImmutableGeoObject;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.ImmutablePolygonKind;
import de.datomino.util.geo.util.GeoUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.math.projection.GeoDecimal100Factory;
import org.ktde.util.algorithm.Algorithm;
import org.ktde.util.algorithm.AlgorithmException;
import org.ktde.util.algorithm.InputDataValidationException;
import org.ktde.util.datatypes.Tupel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOverlapingPolygonReducer<T>
extends Algorithm {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractOverlapingPolygonReducer.class);
    private Map<T, Tupel<Collection<ImmutablePoint>, ImmutablePolygonKind>> input = new HashMap<T, Tupel<Collection<ImmutablePoint>, ImmutablePolygonKind>>();
    private Map<T, ImmutablePolygonKind> result;
    private int maxDepth;
    private boolean ignoreZeroCoords;
    private CoordinateFactory targetFactory;

    protected AbstractOverlapingPolygonReducer(Map<T, Tupel<Collection<ImmutablePoint>, ImmutablePolygonKind>> input, int maxDepth, boolean ignoreZeroCoords) {
        for (Map.Entry<T, Tupel<Collection<ImmutablePoint>, ImmutablePolygonKind>> entry : input.entrySet()) {
            Tupel<Collection<ImmutablePoint>, ImmutablePolygonKind> value = entry.getValue();
            Collection<ImmutablePoint> points = value.getElement1();
            ArrayList<ImmutableGeoObject> list = new ArrayList<ImmutableGeoObject>(points.size());
            for (ImmutablePoint point : points) {
                this.targetFactory = point.getCoordinateFactory();
                list.add(point.getTransformed(GeoDecimal100Factory.INSTANCE));
            }
            this.input.put(entry.getKey(), new Tupel(list, value.getElement2()));
        }
        this.maxDepth = maxDepth;
        this.ignoreZeroCoords = ignoreZeroCoords;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void perform() throws AlgorithmException {
        LOGGER.info("Starting to reduce overlappings");
        Map<T, Tupel<Collection<ImmutablePoint>, ImmutablePolygonKind>> modInput = this.ignoreZeroCoords ? this.filterZeroCords(this.input) : this.input;
        HashMap<T, ImmutablePolygonKind> polygonMap = new HashMap<T, ImmutablePolygonKind>();
        HashMap<Key, Integer> depthMap = new HashMap<Key, Integer>();
        for (Map.Entry<T, Tupel<Collection<ImmutablePoint>, ImmutablePolygonKind>> entry : modInput.entrySet()) {
            void var8_11;
            T key = entry.getKey();
            Tupel<Collection<ImmutablePoint>, ImmutablePolygonKind> value = entry.getValue();
            ImmutablePolygonKind immutablePolygonKind = value.getElement2();
            if (immutablePolygonKind == null) {
                ImmutablePolygonKind immutablePolygonKind2 = this.createPolygon(key, value.getElement1());
            }
            if (var8_11 == null) continue;
            polygonMap.put(key, (ImmutablePolygonKind)var8_11);
        }
        boolean found = true;
        while (found) {
            ArrayList entries = new ArrayList(polygonMap.entrySet());
            found = false;
            int outerCount = 0;
            for (Map.Entry entry : entries) {
                Object key1 = entry.getKey();
                ImmutablePolygonKind polygon1 = (ImmutablePolygonKind)entry.getValue();
                ListIterator iter = entries.listIterator(outerCount + 1);
                while (iter.hasNext()) {
                    Map.Entry entry2 = (Map.Entry)iter.next();
                    Object key2 = entry2.getKey();
                    Key key = new Key(key1, key2);
                    Integer depth = (Integer)depthMap.get(key);
                    if (depth == null) {
                        depth = 0;
                    }
                    if (depth >= this.maxDepth) continue;
                    ImmutablePolygonKind polygon2 = (ImmutablePolygonKind)entry2.getValue();
                    if (!polygon1.isValid()) {
                        polygon1 = this.clearSelfIntersections(polygon1);
                    }
                    if (!polygon2.isValid()) {
                        polygon2 = this.clearSelfIntersections(polygon2);
                    }
                    ImmutableGeoObject intersection = null;
                    try {
                        intersection = polygon1.intersection(polygon2);
                    }
                    catch (TopologyException topologyException) {
                        // empty catch block
                    }
                    if (!(intersection instanceof ImmutablePolygonKind) || !intersection.isValid()) continue;
                    LOGGER.info("Reducing between " + key + " and " + key2);
                    Tupel<ImmutablePolygonKind, ImmutablePolygonKind> tupel = this.handleIntersection(modInput, key1, polygon1, key2, polygon2, intersection);
                    if (tupel == null) continue;
                    found = true;
                    polygon1 = tupel.getElement1();
                    polygonMap.put(key1, polygon1);
                    polygonMap.put(key2, tupel.getElement2());
                    depthMap.put(key, depth + 1);
                }
                ++outerCount;
            }
        }
        if (this.targetFactory != null) {
            this.result = new HashMap<T, ImmutablePolygonKind>();
            for (Map.Entry entry : polygonMap.entrySet()) {
                this.result.put(entry.getKey(), (ImmutablePolygonKind)((ImmutablePolygonKind)entry.getValue()).getTransformed(this.targetFactory));
            }
        } else {
            this.result = polygonMap;
        }
    }

    private Map<T, Tupel<Collection<ImmutablePoint>, ImmutablePolygonKind>> filterZeroCords(Map<T, Tupel<Collection<ImmutablePoint>, ImmutablePolygonKind>> map) {
        HashMap filtered = new HashMap();
        for (Map.Entry<T, Tupel<Collection<ImmutablePoint>, ImmutablePolygonKind>> entry : map.entrySet()) {
            Tupel<Collection<ImmutablePoint>, ImmutablePolygonKind> tupel = entry.getValue();
            Collection<ImmutablePoint> points = tupel.getElement1();
            ArrayList<ImmutablePoint> filteredPoints = new ArrayList<ImmutablePoint>(points.size());
            for (ImmutablePoint point : points) {
                Coordinate coordinate = point.getCoordinate();
                if (coordinate.getX() == 0.0 && coordinate.getY() == 0.0) continue;
                filteredPoints.add(point);
            }
            filtered.put(entry.getKey(), new Tupel(filteredPoints, tupel.getElement2()));
        }
        return filtered;
    }

    private Tupel<ImmutablePolygonKind, ImmutablePolygonKind> handleIntersection(Map<T, Tupel<Collection<ImmutablePoint>, ImmutablePolygonKind>> modInput, Object key1, ImmutablePolygonKind polygon1, Object key2, ImmutablePolygonKind polygon2, ImmutableGeoObject intersection) throws AlgorithmException {
        return this.resolveIntersection(key1, key2, polygon1, polygon2, modInput.get(key1).getElement1(), modInput.get(key2).getElement1(), (ImmutablePolygonKind)intersection);
    }

    private Tupel<ImmutablePolygonKind, ImmutablePolygonKind> resolveIntersection(Object key1, Object key2, ImmutablePolygonKind polygon1, ImmutablePolygonKind polygon2, Collection<ImmutablePoint> points1, Collection<ImmutablePoint> points2, ImmutablePolygonKind intersection) throws AlgorithmException {
        try {
            ImmutablePolygonKind newPolygon2;
            ImmutablePolygonKind newPolygon1;
            Collection<ImmutablePoint> iPoints1 = this.filterPointsInPolygon(intersection, points1);
            Collection<ImmutablePoint> iPoints2 = this.filterPointsInPolygon(intersection, points2);
            boolean empty1 = iPoints1.isEmpty();
            boolean empty2 = iPoints2.isEmpty();
            if (empty1 && empty2) {
                double area2;
                double area1 = polygon1.getArea();
                if (area1 <= (area2 = polygon2.getArea())) {
                    newPolygon1 = polygon1;
                    newPolygon2 = (ImmutablePolygonKind)polygon2.difference(polygon1);
                } else {
                    newPolygon2 = polygon2;
                    newPolygon1 = (ImmutablePolygonKind)polygon1.difference(polygon2);
                }
            } else if (empty1) {
                newPolygon1 = (ImmutablePolygonKind)polygon1.difference(polygon2);
                newPolygon2 = polygon2;
            } else if (empty2) {
                newPolygon2 = (ImmutablePolygonKind)polygon2.difference(polygon1);
                newPolygon1 = polygon1;
            } else {
                boolean areOnStraight1 = GeoUtils.areAllPointsOnStraight(iPoints1);
                boolean areOnStraight2 = GeoUtils.areAllPointsOnStraight(iPoints2);
                if (areOnStraight1 && areOnStraight2) {
                    double area2;
                    double area1 = polygon1.getArea();
                    if (area1 <= (area2 = polygon2.getArea())) {
                        newPolygon1 = polygon1;
                        newPolygon2 = (ImmutablePolygonKind)polygon2.difference(polygon1);
                    } else {
                        newPolygon2 = polygon2;
                        newPolygon1 = (ImmutablePolygonKind)polygon1.difference(polygon2);
                    }
                } else if (areOnStraight1) {
                    newPolygon1 = (ImmutablePolygonKind)polygon1.difference(polygon2);
                    newPolygon2 = polygon2;
                } else if (areOnStraight2) {
                    newPolygon1 = polygon1;
                    newPolygon2 = (ImmutablePolygonKind)polygon2.difference(polygon1);
                } else {
                    double area2;
                    ImmutablePolygonKind subPolygon1 = this.createPolygon(key1, iPoints1);
                    ImmutablePolygonKind subPolygon2 = this.createPolygon(key2, iPoints2);
                    double area1 = polygon1.getArea() + subPolygon1.getArea();
                    if (area1 <= (area2 = polygon2.getArea() + subPolygon2.getArea())) {
                        newPolygon1 = (ImmutablePolygonKind)polygon1.difference(subPolygon2);
                        newPolygon1 = (ImmutablePolygonKind)newPolygon1.union(subPolygon1);
                        newPolygon2 = (ImmutablePolygonKind)polygon2.difference(polygon1);
                        newPolygon2 = (ImmutablePolygonKind)newPolygon2.union(subPolygon2);
                    } else {
                        newPolygon1 = (ImmutablePolygonKind)polygon1.difference(polygon2);
                        newPolygon1 = (ImmutablePolygonKind)newPolygon1.union(subPolygon1);
                        newPolygon2 = (ImmutablePolygonKind)polygon2.difference(subPolygon1);
                        newPolygon2 = (ImmutablePolygonKind)newPolygon2.union(subPolygon2);
                    }
                }
            }
            newPolygon1 = this.clearSelfIntersections(newPolygon1);
            newPolygon2 = this.clearSelfIntersections(newPolygon2);
            if (newPolygon1 == null || !newPolygon1.isValid() || newPolygon2 == null || !newPolygon2.isValid()) {
                return null;
            }
            return new Tupel<ImmutablePolygonKind, ImmutablePolygonKind>(newPolygon1, newPolygon2);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private ImmutablePolygonKind clearSelfIntersections(ImmutablePolygonKind polygon) {
        if (polygon == null) {
            return null;
        }
        if (GeoUtils.isSelfIntersecting(polygon) || !polygon.isValid()) {
            PolygonSelfIntersectionKiller polygonSelfIntersectionKiller = new PolygonSelfIntersectionKiller(polygon);
            polygonSelfIntersectionKiller.start(false);
            polygon = polygonSelfIntersectionKiller.getResult();
        }
        return polygon;
    }

    private Collection<ImmutablePoint> filterPointsInPolygon(ImmutablePolygonKind intersection, Collection<ImmutablePoint> points) {
        LinkedList<ImmutablePoint> list = new LinkedList<ImmutablePoint>();
        for (ImmutablePoint point : points) {
            if (!intersection.contains(point)) continue;
            list.add(point);
        }
        return list;
    }

    @Override
    public int preCalcSteps() {
        return 0;
    }

    @Override
    protected void validateInput() throws InputDataValidationException {
    }

    public Map<T, ImmutablePolygonKind> getResult() {
        return this.result;
    }

    protected abstract ImmutablePolygonKind createPolygon(Object var1, Collection<ImmutablePoint> var2) throws AlgorithmException;

    private static class Key {
        private Object key1;
        private Object key2;

        public Key(Object key1, Object key2) {
            this.key1 = key1;
            this.key2 = key2;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Key) {
                Key other = (Key)obj;
                return new EqualsBuilder().append(this.key1, other.key1).append(this.key2, other.key2).isEquals() || new EqualsBuilder().append(this.key1, other.key2).append(this.key2, other.key1).isEquals();
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.key1).toHashCode() + new HashCodeBuilder().append(this.key2).toHashCode();
        }
    }
}

