/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.algorithm.multipointremover;

import de.datomino.util.geo.ImmutableGeoObject;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutableGeometryCollection;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutableMultiLineString;
import de.datomino.util.geo.ImmutableMultiPolygon;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.ImmutablePolygon;
import de.datomino.util.geo.exception.IllegalPointCountException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.ktde.util.algorithm.Algorithm;
import org.ktde.util.algorithm.AlgorithmException;
import org.ktde.util.algorithm.InputDataValidationException;

public class MultiPointRemover<T extends ImmutableGeoObject>
extends Algorithm {
    private T immutableGeoObject;
    private T result;

    public MultiPointRemover(T immutableGeoObject) {
        this.immutableGeoObject = immutableGeoObject;
    }

    @Override
    protected void perform() throws AlgorithmException {
        this.result = this.removeMultiPoints((ImmutableGeoObject)this.immutableGeoObject);
    }

    private ImmutableGeoObject removeMultiPoints(ImmutableGeoObject immutableGeoObject) {
        if (immutableGeoObject instanceof ImmutableLineString) {
            return this.removeMultiPoints((ImmutableLineString)immutableGeoObject);
        }
        if (immutableGeoObject instanceof ImmutablePolygon) {
            return this.removeMultiPoints((ImmutablePolygon)immutableGeoObject);
        }
        if (immutableGeoObject instanceof ImmutableMultiLineString) {
            return this.removeMultiPoints((ImmutableMultiLineString)immutableGeoObject);
        }
        if (immutableGeoObject instanceof ImmutableMultiPolygon) {
            return this.removeMultiPoints((ImmutableMultiPolygon)immutableGeoObject);
        }
        if (immutableGeoObject instanceof ImmutableGeometryCollection) {
            return this.removeMultiPoints((ImmutableGeometryCollection)immutableGeoObject);
        }
        return immutableGeoObject;
    }

    private ImmutableGeometryCollection removeMultiPoints(ImmutableGeometryCollection immutableGeometryCollection) {
        List<ImmutableGeoObject> parts = immutableGeometryCollection.getParts();
        LinkedList<ImmutableGeoObject> nParts = new LinkedList<ImmutableGeoObject>();
        for (ImmutableGeoObject part : parts) {
            ImmutableGeoObject nPart = this.removeMultiPoints(part);
            if (nPart == null) continue;
            nParts.add(nPart);
        }
        return ImmutableGeoObjectFactory.createImmutableGeometryCollection(nParts, immutableGeometryCollection.getCoordinateFactory());
    }

    private ImmutableMultiPolygon removeMultiPoints(ImmutableMultiPolygon immutableMultiPolygon) {
        List parts = immutableMultiPolygon.getParts();
        LinkedList<ImmutablePolygon> nParts = new LinkedList<ImmutablePolygon>();
        for (ImmutablePolygon polygon : parts) {
            ImmutablePolygon nPart = this.removeMultiPoints(polygon);
            if (nPart == null) continue;
            nParts.add(nPart);
        }
        return ImmutableGeoObjectFactory.createImmutableMultiPolygonByParts(immutableMultiPolygon.getCoordinateFactory(), nParts);
    }

    private ImmutableMultiLineString removeMultiPoints(ImmutableMultiLineString immutableMultiLinestring) {
        List parts = immutableMultiLinestring.getParts();
        LinkedList<ImmutableLineString> nParts = new LinkedList<ImmutableLineString>();
        for (ImmutableLineString part : parts) {
            ImmutableLineString nPart = this.removeMultiPoints(part);
            if (nPart == null) continue;
            nParts.add(nPart);
        }
        return ImmutableGeoObjectFactory.createImmutableMultiLinestring(immutableMultiLinestring.getCoordinateFactory(), nParts);
    }

    private ImmutablePolygon removeMultiPoints(ImmutablePolygon immutablePolygon) {
        ImmutableLineString shell = this.removeMultiPoints(immutablePolygon.getShell());
        if (shell == null) {
            return null;
        }
        LinkedList<ImmutableLineString> nHoles = new LinkedList<ImmutableLineString>();
        for (ImmutableLineString hole : immutablePolygon.getHoles()) {
            ImmutableLineString nHole = this.removeMultiPoints(hole);
            if (nHole == null) continue;
            nHoles.add(nHole);
        }
        try {
            return ImmutableGeoObjectFactory.createImmutablePolygonByLineStrings(shell, nHoles);
        }
        catch (IllegalPointCountException e) {
            return null;
        }
    }

    private ImmutableLineString removeMultiPoints(ImmutableLineString lineString) {
        ImmutablePoint pred;
        List<ImmutablePoint> points = lineString.getCoordinates();
        Iterator<ImmutablePoint> iterator = points.iterator();
        ImmutablePoint immutablePoint = pred = iterator.hasNext() ? iterator.next() : null;
        if (pred != null) {
            LinkedList<ImmutablePoint> nPoints = new LinkedList<ImmutablePoint>();
            nPoints.add(pred);
            while (iterator.hasNext()) {
                ImmutablePoint succ = iterator.next();
                if (succ.equals(pred)) continue;
                nPoints.add(succ);
                pred = succ;
            }
            if (nPoints.size() >= 2) {
                return ImmutableGeoObjectFactory.createImmutableLineStringByPoints(nPoints);
            }
        }
        return null;
    }

    @Override
    public int preCalcSteps() {
        return 0;
    }

    @Override
    protected void validateInput() throws InputDataValidationException {
    }

    public T getResult() {
        return this.result;
    }
}

