/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.algorithm.blockpartitioning.plainbound;

import de.datomino.util.algorithm.blockpartitioning.AbstractBlockPartitioner;
import de.datomino.util.algorithm.blockpartitioning.AbstractBoundPoint;
import de.datomino.util.algorithm.blockpartitioning.BlockPartitionInputDto;
import de.datomino.util.algorithm.blockpartitioning.BoundPointsHolder;
import de.datomino.util.algorithm.blockpartitioning.DummyBoundPoint;
import de.datomino.util.algorithm.blockpartitioning.GeomObjectHolder;
import de.datomino.util.geo.AbstractImmutableValidGeoObject;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.ImmutablePolygon;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class PlainBoundBlockPartitioner
extends AbstractBlockPartitioner {
    public PlainBoundBlockPartitioner(BlockPartitionInputDto blockPartitionInputDto) {
        super(blockPartitionInputDto);
    }

    @Override
    protected Map<GeomObjectHolder, BoundPointsHolder> createPartitionsInternal(Map<GeomObjectHolder, BoundPointsHolder> map, List<GeomObjectHolder> geomObjectHolders, ImmutablePolygon boundingPolygon) {
        LinkedHashMap<GeomObjectHolder, BoundPointsHolder> result = new LinkedHashMap<GeomObjectHolder, BoundPointsHolder>();
        for (GeomObjectHolder geomObjectHolder : geomObjectHolders) {
            BoundPointsHolder origBoundPointsHolder = map.get(geomObjectHolder);
            LinkedList<AbstractBoundPoint> boundPoints = new LinkedList<AbstractBoundPoint>();
            double distanceOnLine = 0.0;
            AbstractImmutableValidGeoObject previous = null;
            for (ImmutablePoint point : geomObjectHolder.getPointsOnLine()) {
                double d = previous == null ? 0.0 : previous.distance(point);
                previous = point;
                boundPoints.add(new DummyBoundPoint(point, DummyBoundPoint.Type.OWN_LINE, distanceOnLine += d));
            }
            BoundPointsHolder newBoundPointsHolder = new BoundPointsHolder(boundPoints, origBoundPointsHolder.getIndex());
            result.put(geomObjectHolder, newBoundPointsHolder);
            this.finishStep();
        }
        return result;
    }

    @Override
    protected int preCalcStepsForCreatePartitionsInternal(BlockPartitionInputDto blockPartitionInputDto) {
        return blockPartitionInputDto.getBlockParts().size();
    }
}

