/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.algorithm.blockpartitioning;

import de.datomino.util.algorithm.blockpartitioning.AbstractBoundPoint;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.util.BasedPoint;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.ktde.math.projection.Coordinate;

public class RegularBoundPoint
extends AbstractBoundPoint {
    private ImmutableLineString lineString;
    private BasedPoint basedPoint;

    public RegularBoundPoint(BasedPoint regularPoint) {
        super(regularPoint.getRefPoint());
        this.basedPoint = regularPoint;
    }

    public ImmutablePoint getAnchorPoint() {
        return this.basedPoint.getBasePoint();
    }

    public ImmutableLineString getLineString() {
        if (this.lineString == null) {
            this.lineString = ImmutableGeoObjectFactory.createImmutableLineString(this.getAnchorPoint().getCoordinate(), this.getPoint().getCoordinate(), new Coordinate[0]);
        }
        return this.lineString;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof RegularBoundPoint) {
            RegularBoundPoint other = (RegularBoundPoint)obj;
            return super.equals(obj) && new EqualsBuilder().append(this.getAnchorPoint(), other.getAnchorPoint()).isEquals();
        }
        return false;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(super.hashCode()).append(this.getAnchorPoint()).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder(this).append("anchorPoint", this.getAnchorPoint()).append("point", this.getPoint()).toString();
    }

    @Override
    public double getLengthOnBaseLine() {
        return this.basedPoint.getDistanceOnBaseline();
    }
}

