/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.algorithm.blockpartitioning;

import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutablePoint;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.ktde.math.projection.Coordinate;

public class GeomObjectHolder {
    private Object geomObject;
    private ImmutableLineString lineString;
    private List<ImmutableLineString> partDistances;
    private List<ImmutablePoint> pointsOnLine;
    private List<ImmutablePoint> pointsOnLineWithoutEndPoints;

    public GeomObjectHolder(Object geomObject, ImmutableLineString lineString) {
        this.geomObject = geomObject;
        this.lineString = lineString;
    }

    public Object getGeomObject() {
        return this.geomObject;
    }

    public List<ImmutableLineString> getPartDistances() {
        if (this.partDistances == null) {
            this.calculatePartDistances();
        }
        return this.partDistances;
    }

    public ImmutableLineString getLineString() {
        return this.lineString;
    }

    public List<ImmutablePoint> getPointsOnLine() {
        if (this.pointsOnLine == null) {
            this.pointsOnLine = this.lineString.getCoordinates();
        }
        return this.pointsOnLine;
    }

    public List<ImmutablePoint> getPointsOnLineWithoutEndPoints() {
        if (this.pointsOnLineWithoutEndPoints == null) {
            List<ImmutablePoint> pointList = this.getPointsOnLine();
            this.pointsOnLineWithoutEndPoints = pointList.subList(1, pointList.size() - 1);
        }
        return this.pointsOnLineWithoutEndPoints;
    }

    private void calculatePartDistances() {
        this.partDistances = new LinkedList<ImmutableLineString>();
        Iterator<ImmutablePoint> pointIter = this.getLineString().getCoordinates().iterator();
        ImmutablePoint pred = pointIter.next();
        while (pointIter.hasNext()) {
            ImmutablePoint succ = pointIter.next();
            this.partDistances.add(ImmutableGeoObjectFactory.createImmutableLineString(pred.getCoordinate(), succ.getCoordinate(), new Coordinate[0]));
            pred = succ;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof GeomObjectHolder) {
            GeomObjectHolder other = (GeomObjectHolder)obj;
            return this.getGeomObject().equals(other.getGeomObject());
        }
        return false;
    }

    public int hashCode() {
        return this.getGeomObject().hashCode();
    }
}

