/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.algorithm.blockpartitioning;

import de.datomino.util.algorithm.blockpartitioning.AbstractBoundPoint;
import de.datomino.util.algorithm.blockpartitioning.BlockPartPartitionInputDto;
import de.datomino.util.algorithm.blockpartitioning.BlockPartitionInputDto;
import de.datomino.util.algorithm.blockpartitioning.BoundPointsHolder;
import de.datomino.util.algorithm.blockpartitioning.DummyBoundPoint;
import de.datomino.util.algorithm.blockpartitioning.GeomObjectHolder;
import de.datomino.util.algorithm.blockpartitioning.RefPointDegenerationRemover;
import de.datomino.util.algorithm.blockpartitioning.RegularBoundPoint;
import de.datomino.util.algorithm.blockpartitioning.ShortCutFinder;
import de.datomino.util.algorithm.blockpartitioning.linewalker.event.BoundPointStepChangedEvent;
import de.datomino.util.algorithm.blockpartitioning.linewalker.event.GeomEvent;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.collection.Transformer;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.ImmutablePolygon;
import de.datomino.util.geo.exception.IllegalPointCountException;
import de.datomino.util.geo.util.BasedPoint;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ktde.math.projection.Coordinate;
import org.ktde.util.algorithm.Algorithm;
import org.ktde.util.algorithm.InputDataValidationException;
import org.ktde.util.datatypes.Tupel;

public abstract class AbstractBlockPartitioner
extends Algorithm {
    protected static final Transformer<AbstractBoundPoint, ImmutablePoint> POINT_STRIP_TRANSFORMER = new Transformer<AbstractBoundPoint, ImmutablePoint>(){

        @Override
        public ImmutablePoint transform(AbstractBoundPoint t) {
            return t.getPoint();
        }
    };
    private RefPointDegenerationRemover refPointDegenerationRemover;
    private ShortCutFinder shortCutFinder;
    private BlockPartitionInputDto blockPartitionInputDto;
    private Map<Object, ImmutableLineString> map;
    private List<ImmutablePoint> innerPoints;

    public AbstractBlockPartitioner(BlockPartitionInputDto blockPartitionInputDto) {
        this.blockPartitionInputDto = blockPartitionInputDto;
    }

    @Override
    protected void perform() {
        Tupel<Map<GeomObjectHolder, BoundPointsHolder>, List<GeomObjectHolder>> tupel = this.transformToAbstractBoundPoints(this.blockPartitionInputDto);
        Map<GeomObjectHolder, BoundPointsHolder> map = tupel.getElement1();
        this.finishStep();
        try {
            ImmutablePolygon boundingPolygon = this.createBlockPolygon(this.blockPartitionInputDto);
            this.finishStep();
            this.fireEvent(new BoundPointStepChangedEvent(this, map));
            if (this.refPointDegenerationRemover != null) {
                map = this.refPointDegenerationRemover.removeDegenerations(map, boundingPolygon);
            }
            map = this.createPartitionsInternal(map, tupel.getElement2(), boundingPolygon);
            if (this.shortCutFinder != null) {
                map = this.shortCutFinder.findShortCuts(map, boundingPolygon);
            }
        }
        catch (IllegalPointCountException e) {
            e.printStackTrace();
        }
        this.map = this.transformToLineString(map);
        this.innerPoints = this.getInnerPoints(map);
        this.finishStep();
    }

    private List<ImmutablePoint> getInnerPoints(Map<GeomObjectHolder, BoundPointsHolder> map) {
        LinkedList<ImmutablePoint> innerPoints = new LinkedList<ImmutablePoint>();
        for (Map.Entry<GeomObjectHolder, BoundPointsHolder> entry : map.entrySet()) {
            for (AbstractBoundPoint boundPoint : entry.getValue().getBoundPoints()) {
                innerPoints.add(boundPoint.getPoint());
            }
        }
        return innerPoints;
    }

    protected abstract Map<GeomObjectHolder, BoundPointsHolder> createPartitionsInternal(Map<GeomObjectHolder, BoundPointsHolder> var1, List<GeomObjectHolder> var2, ImmutablePolygon var3);

    protected abstract int preCalcStepsForCreatePartitionsInternal(BlockPartitionInputDto var1);

    @Override
    public int preCalcSteps() {
        return 3 + this.preCalcStepsForCreatePartitionsInternal(this.blockPartitionInputDto) + (this.refPointDegenerationRemover == null ? 0 : this.refPointDegenerationRemover.preCalcSteps(this.blockPartitionInputDto)) + (this.shortCutFinder == null ? 0 : this.shortCutFinder.preCalcSteps(this.blockPartitionInputDto));
    }

    private ImmutablePolygon createBlockPolygon(BlockPartitionInputDto blockPartitionInputDto) throws IllegalPointCountException {
        LinkedList<ImmutableLineString> extractedLineStrings = new LinkedList<ImmutableLineString>();
        CollectionUtil.transform(blockPartitionInputDto.getBlockParts(), extractedLineStrings, new Transformer<BlockPartPartitionInputDto, ImmutableLineString>(){

            @Override
            public ImmutableLineString transform(BlockPartPartitionInputDto t) {
                return t.getGeomObjectHolder().getLineString();
            }
        });
        ImmutablePolygon polygon = ImmutableGeoObjectFactory.createImmutablePolygonByLineStrings(extractedLineStrings, true);
        this.finishStep();
        return polygon;
    }

    private Map<Object, ImmutableLineString> transformToLineString(Map<GeomObjectHolder, BoundPointsHolder> map) {
        LinkedHashMap<Object, ImmutableLineString> tmap = new LinkedHashMap<Object, ImmutableLineString>();
        for (Map.Entry<GeomObjectHolder, BoundPointsHolder> entry : map.entrySet()) {
            LinkedList<Coordinate> coords = new LinkedList<Coordinate>();
            for (AbstractBoundPoint point : entry.getValue().getBoundPoints()) {
                coords.add(point.getPoint().getCoordinate());
            }
            ImmutableLineString lineString = ImmutableGeoObjectFactory.createImmutableLineString(coords);
            tmap.put(entry.getKey().getGeomObject(), lineString);
        }
        this.finishStep();
        return tmap;
    }

    private Tupel<Map<GeomObjectHolder, BoundPointsHolder>, List<GeomObjectHolder>> transformToAbstractBoundPoints(BlockPartitionInputDto blockPartitionInputDto) {
        LinkedHashMap<GeomObjectHolder, BoundPointsHolder> map = new LinkedHashMap<GeomObjectHolder, BoundPointsHolder>();
        List<BlockPartPartitionInputDto> parts = blockPartitionInputDto.getBlockParts();
        ArrayList<GeomObjectHolder> geomObjectHolders = new ArrayList<GeomObjectHolder>(blockPartitionInputDto.getBlockParts().size());
        int index = 0;
        for (BlockPartPartitionInputDto part : parts) {
            GeomObjectHolder geomObjectHolder = part.getGeomObjectHolder();
            BoundPointsHolder boundPoints = this.createBoundPoints(part, index);
            geomObjectHolders.add(geomObjectHolder);
            map.put(geomObjectHolder, boundPoints);
            ++index;
        }
        return new Tupel<Map<GeomObjectHolder, BoundPointsHolder>, List<GeomObjectHolder>>(map, geomObjectHolders);
    }

    private BoundPointsHolder createBoundPoints(BlockPartPartitionInputDto part, int index) {
        LinkedList<AbstractBoundPoint> boundPoints = new LinkedList<AbstractBoundPoint>();
        ImmutableLineString lineString = part.getGeomObjectHolder().getLineString();
        Iterator<ImmutablePoint> baseLinePointIterator = lineString.getCoordinates().iterator();
        Iterator<BasedPoint> basedPointIterator = part.getEnclosedPoints().iterator();
        ImmutablePoint lastBaseLinePoint = baseLinePointIterator.next();
        boundPoints.add(new DummyBoundPoint(lastBaseLinePoint, DummyBoundPoint.Type.START, 0.0));
        ImmutablePoint nextBaseLinePoint = baseLinePointIterator.next();
        BasedPoint nextBasedPoint = basedPointIterator.hasNext() ? basedPointIterator.next() : null;
        double baseLineDistance = 0.0;
        while (nextBaseLinePoint != null) {
            double nextBaseLineDistance = nextBaseLinePoint.distance(lastBaseLinePoint) + baseLineDistance;
            if (nextBasedPoint != null && nextBaseLineDistance >= nextBasedPoint.getDistanceOnBaseline()) {
                RegularBoundPoint point = new RegularBoundPoint(nextBasedPoint);
                boundPoints.add(point);
                this.fireEvent(new GeomEvent((Object)this, point.getPoint()));
                if (nextBaseLineDistance == nextBasedPoint.getDistanceOnBaseline() && baseLinePointIterator.hasNext()) {
                    lastBaseLinePoint = nextBaseLinePoint;
                    nextBaseLinePoint = baseLinePointIterator.next();
                    baseLineDistance = nextBaseLineDistance;
                }
                nextBasedPoint = basedPointIterator.hasNext() ? basedPointIterator.next() : null;
                continue;
            }
            boundPoints.add(new DummyBoundPoint(nextBaseLinePoint, DummyBoundPoint.Type.OWN_LINE, nextBaseLineDistance));
            lastBaseLinePoint = nextBaseLinePoint;
            nextBaseLinePoint = baseLinePointIterator.hasNext() ? baseLinePointIterator.next() : null;
            baseLineDistance = nextBaseLineDistance;
        }
        return new BoundPointsHolder(boundPoints, index);
    }

    public void setRefPointDegenerationRemover(RefPointDegenerationRemover refPointDegenerationRemover) {
        this.refPointDegenerationRemover = refPointDegenerationRemover;
    }

    public void setShortCutFinder(ShortCutFinder shortCutFinder) {
        this.shortCutFinder = shortCutFinder;
    }

    public Map<Object, ImmutableLineString> getResult() {
        return this.map;
    }

    public List<ImmutablePoint> getInnerPoints() {
        return this.innerPoints;
    }

    @Override
    protected void validateInput() throws InputDataValidationException {
    }
}

