/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util.algorithm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.ktde.util.algorithm.Algorithm;
import org.ktde.util.algorithm.AlgorithmException;
import org.ktde.util.algorithm.InputDataValidationException;
import org.ktde.util.datatypes.Tupel;

public class ComputeStopTime<T>
extends Algorithm {
    private boolean canWait;
    private Map<T, Collection<Tupel<T, Double>>> adjacencyLists;
    private Map<T, Collection<Tupel<Double, Double>>> wayLimits;
    private Map<T, Double> stopWeight;
    private List<T> solution;
    private List<Double> arrivalTimes;

    public ComputeStopTime(List<T> solution, Map<T, Collection<Tupel<T, Double>>> adjacencyLists, Map<T, Collection<Tupel<Double, Double>>> wayLimits, Map<T, Double> stopWeight) {
        this(solution, adjacencyLists, wayLimits, stopWeight, false);
    }

    public ComputeStopTime(List<T> solution, Map<T, Collection<Tupel<T, Double>>> adjacencyLists, Map<T, Collection<Tupel<Double, Double>>> wayLimits, Map<T, Double> stopWeight, boolean canWait) {
        this.canWait = canWait;
        this.adjacencyLists = adjacencyLists;
        this.wayLimits = wayLimits;
        this.stopWeight = stopWeight;
        this.solution = solution;
    }

    @Override
    protected void perform() throws AlgorithmException {
        this.arrivalTimes = new ArrayList<Double>(this.solution.size());
        double currentTime = 0.0;
        Object start = null;
        for (T stop : this.solution) {
            Double deviation;
            Double weight;
            if (start != null) {
                Double min = Double.MAX_VALUE;
                Collection<Tupel<T, Double>> set = this.adjacencyLists.get(start);
                for (Tupel<T, Double> tupel : set) {
                    if (!tupel.getElement1().equals(stop) || !(min > tupel.getElement2())) continue;
                    min = tupel.getElement2();
                }
                currentTime += min.doubleValue();
            }
            Double d = weight = this.stopWeight == null ? null : this.stopWeight.get(stop);
            if (this.canWait && (deviation = ComputeStopTime.getLimitDeviation(currentTime, weight, this.wayLimits.get(stop))) != null) {
                currentTime += deviation.doubleValue();
            }
            this.arrivalTimes.add(currentTime);
            if (weight != null) {
                currentTime += weight.doubleValue();
            }
            start = stop;
        }
    }

    @Override
    public int preCalcSteps() {
        return 1;
    }

    public static Double getLimitDeviation(Double newCurrentValue, Double newCurrentValueDuration, Collection<Tupel<Double, Double>> tupels) {
        if (tupels == null) {
            return 0.0;
        }
        for (Tupel<Double, Double> tupel : tupels) {
            Double lower = tupel.getElement1();
            if (lower == null || lower < newCurrentValue) {
                lower = newCurrentValue;
            }
            Double newCurrentValueExit = lower + newCurrentValueDuration;
            Double upper = tupel.getElement2();
            if (upper != null && !(upper >= newCurrentValueExit)) continue;
            return lower - newCurrentValue;
        }
        return null;
    }

    public List<Double> getArrivalTimes() {
        return this.arrivalTimes;
    }

    public void interrupt() {
    }

    @Override
    protected void validateInput() throws InputDataValidationException {
    }
}

