/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util;

import de.datomino.util.NumericUtil;
import java.util.Random;
import org.apache.commons.lang.StringUtils;

public final class RandomUtil {
    private RandomUtil() {
    }

    public static String nextIntegerString() {
        return RandomUtil.nextIntegerString(Integer.MAX_VALUE);
    }

    public static String nextIntegerString(int n) {
        return RandomUtil.nextIntegerString(n, false);
    }

    public static String nextIntegerString(boolean padWithZeros) {
        return RandomUtil.nextIntegerString(Integer.MAX_VALUE, padWithZeros);
    }

    public static String nextIntegerString(int n, boolean padWithZeros) {
        Random random = new Random();
        int r = random.nextInt(n);
        if (padWithZeros) {
            int length = NumericUtil.getDigitCount(n);
            return StringUtils.leftPad(Integer.toString(r), length, '0');
        }
        return Integer.toString(r);
    }

    public static String nextAsciiString(int chars) {
        Random random = new Random();
        StringBuilder sb = new StringBuilder(chars);
        for (int i = 0; i < chars; ++i) {
            char c = RandomUtil.nextAsciiChar(random);
            sb.append(c);
        }
        return sb.toString();
    }

    public static String nextLetterString(int chars) {
        return RandomUtil.nextLetterString(chars, false);
    }

    public static String nextLetterString(int chars, boolean allowDigits) {
        Random random = new Random();
        StringBuilder sb = new StringBuilder(chars);
        for (int i = 0; i < chars; ++i) {
            boolean s = true;
            if (allowDigits) {
                int p = random.nextInt(62);
                s = p >= 10;
            }
            char c = s ? RandomUtil.nextLetterChar(random) : RandomUtil.nextDigit(random);
            sb.append(c);
        }
        return sb.toString();
    }

    private static char nextDigit(Random random) {
        int c = random.nextInt(10);
        return Integer.toString(c).charAt(0);
    }

    private static char nextAsciiChar(Random random) {
        char c = (char)(33 + random.nextInt(93));
        return c;
    }

    private static char nextLetterChar(Random random) {
        int i = random.nextInt(52);
        i = i >= 26 ? i + 97 - 26 : (i += 65);
        return (char)i;
    }
}

