/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.util;

import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.ktde.util.datatypes.Tupel;

public final class PropertyUtil {
    private PropertyUtil() {
    }

    public static double extractDouble(Properties properties, String propertyName) throws Exception {
        String value = properties.getProperty(propertyName);
        if (value == null) {
            throw new Exception(new NullPointerException());
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException ex) {
            throw new Exception(ex);
        }
    }

    public static double extractDouble(Properties properties, String propertyName, double defaultValue) {
        try {
            return PropertyUtil.extractDouble(properties, propertyName);
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public static List<Tupel<String, String>> getPrefixedProperties(Properties properties, String prefix) {
        LinkedList<Tupel<String, String>> list = new LinkedList<Tupel<String, String>>();
        Enumeration<?> propertyNames = properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String key = propertyNames.nextElement().toString();
            if (!key.startsWith(prefix)) continue;
            String subKey = key.substring(prefix.length());
            list.add(new Tupel<String, String>(subKey, properties.getProperty(key)));
        }
        return list;
    }

    public static Properties mergeProperties(Properties ... properties) {
        Properties props = new Properties();
        for (Properties prop : properties) {
            Enumeration<?> propertyNames = prop.propertyNames();
            while (propertyNames.hasMoreElements()) {
                String property;
                String key = (String)propertyNames.nextElement();
                if (props.containsKey(key) || (property = prop.getProperty(key)) == null) continue;
                props.setProperty(key, property);
            }
        }
        return props;
    }
}

