/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.tools.maven.pomeditor;

import de.datomino.tools.maven.pomeditor.ArtifactDescriptor;
import de.datomino.tools.maven.pomeditor.filter.ArtifactFilter;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class PomVersionExtractor {
    private static final DocumentBuilder DOCUMENT_BUILDER;
    private static final Pattern VERSION_PATTERN;

    public static Set<ArtifactDescriptor> findFullQualifiedArtifacts(File pom, ArtifactFilter artifactFilter) throws SAXException, IOException {
        System.out.println(pom.getCanonicalPath());
        LinkedHashSet<ArtifactDescriptor> artifactDescriptors = new LinkedHashSet<ArtifactDescriptor>();
        Document document = DOCUMENT_BUILDER.parse(pom);
        NodeList nodeList = document.getElementsByTagName("version");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node versionNode = nodeList.item(i);
            ArtifactDescriptor artifactDescriptor = PomVersionExtractor.getArtifactDescriptor(versionNode);
            if (!artifactFilter.filter(artifactDescriptor)) continue;
            artifactDescriptors.add(artifactDescriptor);
        }
        return artifactDescriptors;
    }

    public static void replaceVersions(File pom, Map<ArtifactDescriptor, String> map) throws IOException, SAXException {
        Document document = DOCUMENT_BUILDER.parse(pom);
        NodeList nodeList = document.getElementsByTagName("version");
        LinkedList<String> replacements = new LinkedList<String>();
        boolean found = false;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node versionNode = nodeList.item(i);
            ArtifactDescriptor artifactDescriptor = PomVersionExtractor.getArtifactDescriptor(versionNode);
            String replacement = map.get(artifactDescriptor);
            found |= replacement != null;
            replacements.add(replacement);
        }
        if (found) {
            String content = FileUtils.readFileToString(pom, "UTF-8");
            Matcher matcher = VERSION_PATTERN.matcher(content);
            StringBuilder sb = new StringBuilder(content.length());
            int currentIndex = 0;
            for (String replacement : replacements) {
                matcher.find();
                sb.append(content.substring(currentIndex, matcher.start())).append("<version>").append(replacement == null ? matcher.group(1) : replacement).append("</version>");
                currentIndex = matcher.end();
            }
            sb.append(content.substring(currentIndex, content.length()));
            FileUtils.writeStringToFile(pom, sb.toString(), "UTF-8");
        }
    }

    private static ArtifactDescriptor getArtifactDescriptor(Node versionNode) {
        String version = versionNode.getNodeValue();
        Node parentNode = versionNode.getParentNode();
        NodeList childs = parentNode.getChildNodes();
        String artifactId = null;
        String groupId = null;
        for (int j = 0; j < childs.getLength(); ++j) {
            Node child = childs.item(j);
            String nodeName = child.getNodeName();
            if (nodeName == null) continue;
            if (nodeName.equals("artifactId")) {
                artifactId = child.getNodeValue();
                continue;
            }
            if (!nodeName.equals("groupId")) continue;
            groupId = child.getNodeValue();
        }
        return new ArtifactDescriptor(groupId, artifactId, version);
    }

    static {
        VERSION_PATTERN = Pattern.compile("<version>(.*)</version>");
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        DOCUMENT_BUILDER = documentBuilder;
    }
}

