/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.tools.database2.dag.transition;

import de.datomino.tools.database2.dag.transition.SqlTransition;
import de.datomino.tools.database2.log.DatabaseLog;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.ktde.util.StringUtil;

public class IgnoringErrorSqlTransition
extends SqlTransition {
    public IgnoringErrorSqlTransition(List<String> args, DatabaseLog databaseLog) {
        super(args, databaseLog);
    }

    @Override
    protected void executeStatement(Statement stat, String input, Connection con) throws SQLException {
        con.commit();
        String uInput = StringUtil.removeComments(input, "/*", "*/");
        uInput = StringUtil.removeEndOfLineComments(uInput, "--");
        StringBuilder sb = new StringBuilder();
        Character openQuote = null;
        for (int i = 0; i < uInput.length(); ++i) {
            char c = uInput.charAt(i);
            if (c == '\'' || c == '\"') {
                if (openQuote == null) {
                    openQuote = Character.valueOf(c);
                } else if (openQuote.charValue() == c) {
                    openQuote = null;
                }
                sb.append(c);
                continue;
            }
            if (c == '\n' && openQuote == null) {
                sb.append(" ");
                continue;
            }
            if (c == ';') {
                String sql = sb.toString();
                if (!sql.trim().isEmpty()) {
                    this.getDatabaseLog().info("Executing Statement: " + sql);
                    try {
                        stat.execute("BEGIN");
                        stat.execute(sql);
                        con.commit();
                    }
                    catch (Exception e) {
                        con.rollback();
                        this.getDatabaseLog().warn(e.getMessage());
                    }
                }
                sb = new StringBuilder();
                continue;
            }
            sb.append(c);
        }
        String sql = sb.toString();
        if (!sql.trim().isEmpty()) {
            this.getDatabaseLog().info("Executing Statement: " + sql);
            try {
                stat.execute("BEGIN");
                stat.execute(sql);
                con.commit();
            }
            catch (Exception e) {
                con.rollback();
                this.getDatabaseLog().warn(e.getMessage());
            }
        }
        stat.execute("BEGIN");
    }
}

