/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.tools.database2.dag.transition;

import de.datomino.tools.database2.FeatureDatabaseDescriptor;
import de.datomino.tools.database2.dag.transition.AbstractTransition;
import de.datomino.tools.database2.exception.DatabaseToolException;
import de.datomino.tools.database2.log.DatabaseLog;
import java.io.IOException;
import java.sql.Connection;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class CommandLineSqlTransition
extends AbstractTransition {
    protected CommandLineSqlTransition(List<String> args, DatabaseLog databaseLog) {
        super(args, databaseLog);
    }

    @Override
    protected boolean executeInternal(FeatureDatabaseDescriptor descriptor, Connection con) throws DatabaseToolException {
        String filename = this.getArgs().get(0);
        String command = descriptor.getSqlCommandPrefix() + " " + filename;
        try {
            this.getDatabaseLog().info("Executing \"" + command + "\"");
            this.getDatabaseLog().info("Execute?");
            if (this.askToContinue(descriptor)) {
                Process p = Runtime.getRuntime().exec(command);
                int d = p.waitFor();
                if (d != 0) {
                    throw new DatabaseToolException("File execution failed:\n" + IOUtils.toString(p.getInputStream()) + "\n" + IOUtils.toString(p.getErrorStream()));
                }
                return true;
            }
        }
        catch (IOException e) {
            throw new DatabaseToolException(e);
        }
        catch (InterruptedException e) {
            throw new DatabaseToolException(e);
        }
        return false;
    }
}

