/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.tools.database2.dag.transition;

import de.datomino.tools.database2.ConfirmationMode;
import de.datomino.tools.database2.FeatureDatabaseDescriptor;
import de.datomino.tools.database2.dag.Dag;
import de.datomino.tools.database2.exception.DatabaseToolException;
import de.datomino.tools.database2.log.DatabaseLog;
import java.io.IOException;
import java.sql.Connection;
import java.util.List;

public abstract class AbstractTransition {
    private List<String> args;
    private Dag dag;
    private DatabaseLog databaseLog;

    protected AbstractTransition(List<String> args, DatabaseLog databaseLog) {
        this.args = args;
        this.databaseLog = databaseLog;
    }

    public final boolean execute(FeatureDatabaseDescriptor descriptor, Connection con) throws DatabaseToolException {
        this.getDatabaseLog().info("Installing " + this.dag.getName());
        return this.executeInternal(descriptor, con);
    }

    protected abstract boolean executeInternal(FeatureDatabaseDescriptor var1, Connection var2) throws DatabaseToolException;

    protected List<String> getArgs() {
        return this.args;
    }

    protected Dag getDag() {
        return this.dag;
    }

    public void setDag(Dag dag) {
        this.dag = dag;
    }

    protected boolean askToContinue(FeatureDatabaseDescriptor featureDatabaseDescriptor) throws IOException {
        if (featureDatabaseDescriptor.getConfirmationMode() == ConfirmationMode.SINGLE) {
            char c;
            this.getDatabaseLog().info("Execute? (y/n)");
            do {
                if ((c = Character.toLowerCase((char)System.in.read())) != 'y') continue;
                return true;
            } while (c != 'n');
            return false;
        }
        return true;
    }

    protected DatabaseLog getDatabaseLog() {
        return this.databaseLog;
    }
}

