/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.tools.database2.dag;

import de.datomino.tools.database2.dag.Dag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class DagCalculator {
    public static List<List<Dag>> calculateDags(Collection<Dag> dags, Set<String> features, String feature) {
        if (features.contains(feature)) {
            return null;
        }
        Collection<Dag> inputFeaturesDags = DagCalculator.findMatchingDags(features, dags);
        for (Dag dag : inputFeaturesDags) {
            DagCalculator.findMatchingDagsRek(dag, features, dags, new HashSet<Dag>());
        }
        return DagCalculator.findWay(inputFeaturesDags, feature, features);
    }

    private static void findMatchingDagsRek(Dag dag, Set<String> features, Collection<Dag> allDags, Set<Dag> alreadyCalculated) {
        alreadyCalculated.add(dag);
        HashSet<String> featuresAfterDag = new HashSet<String>(features);
        featuresAfterDag.addAll(dag.getToBeSet());
        featuresAfterDag.removeAll(dag.getToBeDeleted());
        Collection<Dag> children = DagCalculator.findMatchingDags(featuresAfterDag, allDags);
        dag.addChildren(children);
        for (Dag child : children) {
            if (alreadyCalculated.contains(child)) continue;
            DagCalculator.findMatchingDagsRek(child, featuresAfterDag, allDags, alreadyCalculated);
        }
    }

    private static Collection<Dag> findMatchingDags(Set<String> features, Collection<Dag> dagsToSearch) {
        HashSet<Dag> matchingDags = new HashSet<Dag>();
        for (Dag dag : dagsToSearch) {
            if (!dag.satisfiesCondition(features)) continue;
            matchingDags.add(dag);
        }
        return matchingDags;
    }

    private static List<List<Dag>> findWay(Collection<Dag> dags, String feature, Collection<String> features) {
        LinkedList<List<Dag>> ways = new LinkedList<List<Dag>>();
        for (Dag dag : dags) {
            ways.addAll(DagCalculator.findFeatureRek(dag, feature, new HashSet<Dag>(), features));
        }
        return DagCalculator.cleanSameFeatures(ways);
    }

    private static List<List<Dag>> cleanSameFeatures(List<List<Dag>> ways) {
        ArrayList<List<Dag>> cleaned = new ArrayList<List<Dag>>(ways.size());
        block0: for (List<Dag> way : ways) {
            for (List list : cleaned) {
                if (!way.containsAll(list) || !list.containsAll(way)) continue;
                continue block0;
            }
            cleaned.add(way);
        }
        return cleaned;
    }

    private static List<List<Dag>> findFeatureRek(Dag dag, String feature, Set<Dag> alreadyVisited, Collection<String> features) {
        alreadyVisited.add(dag);
        if (dag.getName().equalsIgnoreCase(feature)) {
            return Collections.singletonList(Collections.singletonList(dag));
        }
        ArrayList<List<Dag>> rways = new ArrayList<List<Dag>>();
        HashSet<String> newFeatures = new HashSet<String>(features);
        newFeatures.addAll(dag.getToBeSet());
        newFeatures.removeAll(dag.getToBeDeleted());
        for (Dag child : dag.getChildren()) {
            if (alreadyVisited.contains(child) || !child.satisfiesCondition(newFeatures)) continue;
            List<List<Dag>> ways = DagCalculator.findFeatureRek(child, feature, alreadyVisited, newFeatures);
            for (List<Dag> way : ways) {
                ArrayList<Dag> extendendWay = new ArrayList<Dag>();
                extendendWay.add(dag);
                extendendWay.addAll(way);
                rways.add(extendendWay);
            }
        }
        return rways;
    }
}

