/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.tools.database2;

import de.datomino.tools.database2.ConfirmationMode;
import de.datomino.tools.database2.DatabaseTool;
import de.datomino.tools.database2.FeatureDatabaseDescriptor;
import de.datomino.tools.database2.dag.DagException;
import de.datomino.tools.database2.exception.DatabaseToolException;
import de.datomino.tools.database2.log.ConsoleDatabaseLog;
import java.io.IOException;
import java.sql.SQLException;
import org.ktde.util.StringUtil;

public class DatabaseToolMain {
    public static void main(String[] args) throws SQLException, IOException, DagException, DatabaseToolException, ClassNotFoundException {
        String pwHiddenString;
        String profile = args.length > 0 ? args[0] : null;
        String string = pwHiddenString = args.length > 1 ? args[1] : null;
        boolean pwHidden = StringUtil.isBlank(pwHiddenString) ? true : !pwHiddenString.equalsIgnoreCase("pwShow");
        String driver = "org.postgresql.Driver";
        String host = "localhost";
        Integer port = 5432;
        String user = "postgres";
        String password = "";
        String dialect = "postgres";
        String plainUrlPattern = "jdbc:%%%DIALECT%%%ql://%%%HOST%%%:%%%PORT%%%/";
        String urlPattern = "jdbc:%%%DIALECT%%%ql://%%%HOST%%%:%%%PORT%%%/%%%DATABASE%%%";
        String featureTablename = "installed_features";
        String databaseName = "";
        String featureDirectory = "update-descriptors";
        String sqlRootDirectory = "sql";
        ConfirmationMode confirmationMode = ConfirmationMode.SINGLE;
        String feature = "";
        if (profile != null && profile.equalsIgnoreCase("db2")) {
            driver = "com.ibm.db2.jcc.DB2Driver";
            port = 50055;
            user = "db2inst2";
            dialect = "db2";
            plainUrlPattern = "jdbc:%%%DIALECT%%%://%%%HOST%%%:%%%PORT%%%/";
            urlPattern = "jdbc:%%%DIALECT%%%://%%%HOST%%%:%%%PORT%%%/%%%DATABASE%%%";
            password = "test";
        }
        driver = DatabaseToolMain.readLine("Driver", driver, false);
        host = DatabaseToolMain.readLine("Host", host, false);
        port = Integer.valueOf(DatabaseToolMain.readLine("Port", port.toString(), false));
        user = DatabaseToolMain.readLine("User", user, false);
        password = DatabaseToolMain.readLine("Password", password, pwHidden);
        dialect = DatabaseToolMain.readLine("Dialect", dialect, false);
        plainUrlPattern = DatabaseToolMain.readLine("Plain Url Pattern", plainUrlPattern, false);
        urlPattern = DatabaseToolMain.readLine("Url Pattern", urlPattern, false);
        featureTablename = DatabaseToolMain.readLine("Feature table name", featureTablename, false);
        databaseName = DatabaseToolMain.readLine("Database name", databaseName, false);
        featureDirectory = DatabaseToolMain.readLine("Feature directoy", featureDirectory, false);
        sqlRootDirectory = DatabaseToolMain.readLine("Sql-Root-Directory", sqlRootDirectory, false);
        confirmationMode = ConfirmationMode.valueOf(DatabaseToolMain.readLine("Confirmation mode", confirmationMode.name(), false));
        feature = DatabaseToolMain.readLine("Feature", feature, false);
        FeatureDatabaseDescriptor featureDatabaseDescriptor = new FeatureDatabaseDescriptor();
        featureDatabaseDescriptor.setConfirmationMode(confirmationMode);
        featureDatabaseDescriptor.setDatabaseName(databaseName);
        featureDatabaseDescriptor.setDialect(dialect);
        featureDatabaseDescriptor.setDriver(driver);
        featureDatabaseDescriptor.setFeatureDirectory(featureDirectory);
        featureDatabaseDescriptor.setFeatureTableName(featureTablename);
        featureDatabaseDescriptor.setHost(host);
        featureDatabaseDescriptor.setPassword(password);
        featureDatabaseDescriptor.setPattern(urlPattern);
        featureDatabaseDescriptor.setPlainPattern(plainUrlPattern);
        featureDatabaseDescriptor.setPort(port);
        featureDatabaseDescriptor.setUser(user);
        featureDatabaseDescriptor.setSqlRootDirectory(sqlRootDirectory);
        Class.forName(driver);
        DatabaseTool.executeUpdate(featureDatabaseDescriptor, feature, new ConsoleDatabaseLog());
    }

    private static String readLine(String param, String defaultValue, boolean hidden) {
        System.out.println(param + " [" + defaultValue + "]:");
        try {
            EraserThread eraserThread = null;
            if (hidden) {
                eraserThread = new EraserThread();
                eraserThread.start();
            }
            StringBuilder sb = new StringBuilder();
            char c = (char)System.in.read();
            while (c != '\n') {
                sb.append(c);
                c = (char)System.in.read();
            }
            if (hidden) {
                eraserThread.finish();
            }
            String r = sb.toString();
            if (defaultValue != null && r.isEmpty()) {
                r = defaultValue;
            }
            return r;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static class EraserThread
    extends Thread {
        private boolean stopped = false;

        private EraserThread() {
        }

        @Override
        public void run() {
            while (!this.stopped) {
                System.out.print("\b");
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public void finish() {
            this.stopped = true;
        }
    }
}

