/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.tools.database2;

import de.datomino.tools.database2.SimpleDatabaseDescriptor;
import de.datomino.tools.database2.log.DatabaseLog;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class DatabaseInitializer {
    public static void initializeDatabase(Properties props, DatabaseLog databaseLog, boolean createDatabase, String productionUser, String databaseTemplate) throws SQLException {
        SimpleDatabaseDescriptor simpleDatabaseDescriptor = new SimpleDatabaseDescriptor(props, databaseLog);
        DatabaseInitializer.initializeDatabase(simpleDatabaseDescriptor, createDatabase, productionUser, databaseTemplate);
    }

    public static void initializeDatabase(SimpleDatabaseDescriptor simpleDatabaseDescriptor, boolean createDatabase, String productionUser, String databaseTemplate) throws SQLException {
        Connection con;
        if (createDatabase) {
            String create;
            con = simpleDatabaseDescriptor.createPlainConnection();
            con.setAutoCommit(true);
            Statement statement = con.createStatement();
            String databaseName = simpleDatabaseDescriptor.getDatabaseName();
            String dialect = simpleDatabaseDescriptor.getDialect().toLowerCase();
            if (dialect.equals("postgresql") || dialect.equals("postgres")) {
                create = "CREATE DATABASE " + databaseName + " with template = " + databaseTemplate + (productionUser == null ? "" : " OWNER = " + productionUser) + " encoding = 'UTF8' connection limit = -1;";
            } else if (dialect.equals("db2")) {
                create = "CREATE DATABASE " + databaseName + " with encoding = 'UTF8' connection limit = -1;";
            } else {
                throw new SQLException("Unknown dialect: " + dialect);
            }
            statement.execute(create);
            statement.close();
            con.close();
        }
        con = simpleDatabaseDescriptor.createConnection();
        String tablename = simpleDatabaseDescriptor.getFeatureTableName();
        Statement statement = con.createStatement();
        statement.execute("CREATE TABLE public.t_" + tablename + "(feature_name character varying(255) NOT NULL, CONSTRAINT p_" + tablename + " PRIMARY KEY (feature_name));");
        statement.close();
        con.commit();
        con.close();
    }
}

