/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.tools.common;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class CommandLineProperties {
    private List<String> commands;
    private Map<String, List<String>> switches;

    CommandLineProperties() {
    }

    CommandLineProperties(List<String> commands, Map<String, List<String>> switches) {
        this.commands = Collections.unmodifiableList(commands);
        this.switches = Collections.unmodifiableMap(switches);
    }

    void setCommands(List<String> commands) {
        this.commands = Collections.unmodifiableList(commands);
    }

    void setSwitches(Map<String, List<String>> switches) {
        this.switches = Collections.unmodifiableMap(switches);
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public Map<String, List<String>> getSwitches() {
        return this.switches;
    }

    public Properties getProperties() {
        Properties props = new Properties();
        int count = 0;
        for (String string : this.commands) {
            props.put("COMMAND_" + count, string);
            ++count;
        }
        for (Map.Entry entry : this.switches.entrySet()) {
            List value = (List)entry.getValue();
            props.put(entry.getKey(), value.isEmpty() ? "true" : StringUtils.join((Collection)value, ','));
        }
        return props;
    }
}

